/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.crypto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nervos.appchain.crypto.CipherException;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.crypto.ECKeyPair;
import org.nervos.appchain.crypto.Keys;
import org.nervos.appchain.crypto.Wallet;
import org.nervos.appchain.crypto.WalletFile;
import org.nervos.appchain.utils.Numeric;

public class WalletUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static String generateFullNewWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return WalletUtils.generateNewWalletFile(password, destinationDirectory, true);
    }

    public static String generateLightNewWalletFile(String password, File destinationDirectory) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CipherException, IOException {
        return WalletUtils.generateNewWalletFile(password, destinationDirectory, false);
    }

    public static String generateNewWalletFile(String password, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        return WalletUtils.generateWalletFile(password, ecKeyPair, destinationDirectory, useFullScrypt);
    }

    public static String generateWalletFile(String password, ECKeyPair ecKeyPair, File destinationDirectory, boolean useFullScrypt) throws CipherException, IOException {
        WalletFile walletFile = useFullScrypt ? Wallet.createStandard(password, ecKeyPair) : Wallet.createLight(password, ecKeyPair);
        String fileName = WalletUtils.getWalletFileName(walletFile);
        File destination = new File(destinationDirectory, fileName);
        objectMapper.writeValue(destination, (Object)walletFile);
        return fileName;
    }

    public static Credentials loadCredentials(String password, String source) throws IOException, CipherException {
        return WalletUtils.loadCredentials(password, new File(source));
    }

    public static Credentials loadCredentials(String password, File source) throws IOException, CipherException {
        WalletFile walletFile = (WalletFile)objectMapper.readValue(source, WalletFile.class);
        return Credentials.create(Wallet.decrypt(password, walletFile));
    }

    private static String getWalletFileName(WalletFile walletFile) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("'UTC--'yyyy-MM-dd'T'HH-mm-ss.SSS'--'");
        return dateFormat.format(new Date()) + walletFile.getAddress() + ".json";
    }

    public static String getDefaultKeyDirectory() {
        return WalletUtils.getDefaultKeyDirectory(System.getProperty("os.name"));
    }

    static String getDefaultKeyDirectory(String osName1) {
        String osName = osName1.toLowerCase();
        if (osName.startsWith("mac")) {
            return String.format("%s%sLibrary%sEthereum", System.getProperty("user.home"), File.separator, File.separator);
        }
        if (osName.startsWith("win")) {
            return String.format("%s%sEthereum", System.getenv("APPDATA"), File.separator);
        }
        return String.format("%s%s.ethereum", System.getProperty("user.home"), File.separator);
    }

    public static String getTestnetKeyDirectory() {
        return String.format("%s%stestnet%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator, File.separator);
    }

    public static String getMainnetKeyDirectory() {
        return String.format("%s%skeystore", WalletUtils.getDefaultKeyDirectory(), File.separator);
    }

    public static boolean isValidPrivateKey(String privateKey) {
        String cleanPrivateKey = Numeric.cleanHexPrefix((String)privateKey);
        return cleanPrivateKey.length() == 64;
    }

    public static boolean isValidAddress(String input) {
        String cleanInput = Numeric.cleanHexPrefix((String)input);
        try {
            Numeric.toBigIntNoPrefix((String)cleanInput);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return cleanInput.length() == 40;
    }

    static {
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

