/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.crypto;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nervos.appchain.crypto.ECKeyPair;
import org.nervos.appchain.crypto.Keys;
import org.nervos.appchain.crypto.SampleKeys;
import org.nervos.appchain.utils.Numeric;
import org.nervos.appchain.utils.Strings;

public class KeysTest {
    private static final byte[] ENCODED;

    @Test
    public void testCreateSecp256k1KeyPair() throws Exception {
        KeyPair keyPair = Keys.createSecp256k1KeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        Assert.assertNotNull((Object)privateKey);
        Assert.assertNotNull((Object)publicKey);
        Assert.assertThat((Object)privateKey.getEncoded().length, (Matcher)CoreMatchers.is((Object)144));
        Assert.assertThat((Object)publicKey.getEncoded().length, (Matcher)CoreMatchers.is((Object)88));
    }

    @Test
    public void testCreateEcKeyPair() throws Exception {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        Assert.assertThat((Object)ecKeyPair.getPublicKey().signum(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)ecKeyPair.getPrivateKey().signum(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testGetAddressString() {
        Assert.assertThat((Object)Keys.getAddress((String)"0x506bc1dc099358e5137292f4efdd57e400f29ba5132aa5d12b18dac1c1f6aaba645c0b7b58158babbfa6c6cd5a48aa7340a8749176b120e8516216787a13dc76"), (Matcher)CoreMatchers.is((Object)SampleKeys.ADDRESS_NO_PREFIX));
    }

    @Test
    public void testGetAddressZeroPaddedAddress() {
        String publicKey = "0xa1b31be4d58a7ddd24b135db0da56a90fb5382077ae26b250e1dc9cd6232ce2270f4c995428bc76aa78e522316e95d7834d725efc9ca754d043233af6ca90113";
        Assert.assertThat((Object)Keys.getAddress((String)publicKey), (Matcher)CoreMatchers.is((Object)"01c52b08330e05d731e38c856c1043288f7d9744"));
    }

    @Test
    public void testGetAddressBigInteger() {
        Assert.assertThat((Object)Keys.getAddress((BigInteger)SampleKeys.PUBLIC_KEY), (Matcher)CoreMatchers.is((Object)SampleKeys.ADDRESS_NO_PREFIX));
    }

    @Test
    public void testGetAddressSmallPublicKey() {
        byte[] address = Keys.getAddress((byte[])Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(4660L), (int)64));
        String expected = Numeric.toHexStringNoPrefix((byte[])address);
        Assert.assertThat((Object)Keys.getAddress((String)"0x1234"), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testGetAddressZeroPadded() {
        byte[] address = Keys.getAddress((byte[])Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(4660L), (int)64));
        String expected = Numeric.toHexStringNoPrefix((byte[])address);
        String value = "1234";
        Assert.assertThat((Object)Keys.getAddress((String)("0x" + Strings.zeros((int)(128 - value.length())) + value)), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testSerializeECKey() {
        Assert.assertThat((Object)Keys.serialize((ECKeyPair)SampleKeys.KEY_PAIR), (Matcher)CoreMatchers.is((Object)ENCODED));
    }

    @Test
    public void testDeserializeECKey() {
        Assert.assertThat((Object)Keys.deserialize((byte[])ENCODED), (Matcher)CoreMatchers.is((Object)SampleKeys.KEY_PAIR));
    }

    @Test(expected=RuntimeException.class)
    public void testDeserializeInvalidKey() {
        Keys.deserialize((byte[])new byte[0]);
    }

    static {
        byte[] privateKey = Numeric.hexStringToByteArray((String)"a392604efc2fad9c0b3da43b5f698a2e3f270f170d859912be0d54742275c5f6");
        byte[] publicKey = Numeric.hexStringToByteArray((String)"0x506bc1dc099358e5137292f4efdd57e400f29ba5132aa5d12b18dac1c1f6aaba645c0b7b58158babbfa6c6cd5a48aa7340a8749176b120e8516216787a13dc76");
        ENCODED = Arrays.copyOf(privateKey, privateKey.length + publicKey.length);
        System.arraycopy(publicKey, 0, ENCODED, privateKey.length, publicKey.length);
    }
}

