/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.crypto;

import java.math.BigInteger;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.nervos.appchain.crypto.Credentials;
import org.nervos.appchain.crypto.RawTransaction;
import org.nervos.appchain.crypto.SampleKeys;
import org.nervos.appchain.crypto.Sign;
import org.nervos.appchain.crypto.TransactionEncoder;
import org.nervos.appchain.rlp.RlpString;
import org.nervos.appchain.utils.Numeric;

public class TransactionEncoderTest {
    @Test
    public void testSignMessage() {
        byte[] signedMessage = TransactionEncoder.signMessage((RawTransaction)TransactionEncoderTest.createEtherTransaction(), (Credentials)SampleKeys.CREDENTIALS);
        String hexMessage = Numeric.toHexString((byte[])signedMessage);
        Assert.assertThat((Object)hexMessage, (Matcher)CoreMatchers.is((Object)"0xf86080010a840add535593393232333337323033363835343737353830378001a0dd9316183231a788f61b8797d8f91abac283159ad343eb19a09e048616c9afb7a01c9bf41469e6bdffd8e39c350c053c5b311cdedf481caea071fa43682afc1472"));
    }

    @Test
    public void testEtherTransactionAsRlpValues() {
        List rlpStrings = TransactionEncoder.asRlpValues((RawTransaction)TransactionEncoderTest.createEtherTransaction(), (Sign.SignatureData)new Sign.SignatureData(0, new byte[32], new byte[32]));
        Assert.assertThat((Object)rlpStrings.size(), (Matcher)CoreMatchers.is((Object)9));
        Assert.assertThat(rlpStrings.get(3), (Matcher)IsEqual.equalTo((Object)RlpString.create((BigInteger)new BigInteger("add5355", 16))));
    }

    @Test
    public void testContractAsRlpValues() {
        List rlpStrings = TransactionEncoder.asRlpValues((RawTransaction)TransactionEncoderTest.createContractTransaction(), null);
        Assert.assertThat((Object)rlpStrings.size(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat(rlpStrings.get(3), (Matcher)CoreMatchers.is((Object)RlpString.create((String)"")));
    }

    @Test
    public void testEip155Encode() {
        Assert.assertThat((Object)TransactionEncoder.encode((RawTransaction)TransactionEncoderTest.createEip155RawTransaction(), (byte)1), (Matcher)CoreMatchers.is((Object)Numeric.hexStringToByteArray((String)"f837098504a817c800825208943535353535353535353535353535353535353535933130303030303030303030303030303030303080018080")));
    }

    @Test
    public void testEip155Transaction() {
        Credentials credentials = Credentials.create((String)"0x4646464646464646464646464646464646464646464646464646464646464646");
        Assert.assertThat((Object)TransactionEncoder.signMessage((RawTransaction)TransactionEncoderTest.createEip155RawTransaction(), (byte)1, (Credentials)credentials), (Matcher)CoreMatchers.is((Object)Numeric.hexStringToByteArray((String)"f877098504a817c8008252089435353535353535353535353535353535353535359331303030303030303030303030303030303030800aa080f800b1b9cbd6a09d063f7f4857aa271ffd34bedd7cbc65ec672f7c21f16798a017ac2005fccd66cd6743d7cdde2cc47b75cee987e161f7f0815d6e0accf24009")));
    }

    private static RawTransaction createEtherTransaction() {
        return RawTransaction.createEtherTransaction((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TEN, (String)"0xadd5355", (String)String.valueOf(Long.MAX_VALUE));
    }

    static RawTransaction createContractTransaction() {
        return RawTransaction.createContractTransaction((BigInteger)BigInteger.ZERO, (BigInteger)BigInteger.ONE, (BigInteger)BigInteger.TEN, (String)String.valueOf(Long.MAX_VALUE), (String)"01234566789");
    }

    private static RawTransaction createEip155RawTransaction() {
        return RawTransaction.createEtherTransaction((BigInteger)BigInteger.valueOf(9L), (BigInteger)BigInteger.valueOf(20000000000L), (BigInteger)BigInteger.valueOf(21000L), (String)"0x3535353535353535353535353535353535353535", (String)String.valueOf(1000000000000000000L));
    }
}

