/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.rlp;

import java.math.BigInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nervos.appchain.rlp.RlpEncoder;
import org.nervos.appchain.rlp.RlpList;
import org.nervos.appchain.rlp.RlpString;
import org.nervos.appchain.rlp.RlpType;

public class RlpEncoderTest {
    @Test
    public void testEncode() {
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((String)"dog")), (Matcher)CoreMatchers.is((Object)new byte[]{-125, 100, 111, 103}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)new RlpList(new RlpType[]{RlpString.create((String)"cat"), RlpString.create((String)"dog")})), (Matcher)CoreMatchers.is((Object)new byte[]{-56, -125, 99, 97, 116, -125, 100, 111, 103}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((String)"")), (Matcher)CoreMatchers.is((Object)new byte[]{-128}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((byte[])new byte[0])), (Matcher)CoreMatchers.is((Object)new byte[]{-128}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)new RlpList(new RlpType[0])), (Matcher)CoreMatchers.is((Object)new byte[]{-64}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((BigInteger)BigInteger.valueOf(15L))), (Matcher)CoreMatchers.is((Object)new byte[]{15}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((BigInteger)BigInteger.valueOf(1024L))), (Matcher)CoreMatchers.is((Object)new byte[]{-126, 4, 0}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)new RlpList(new RlpType[]{new RlpList(new RlpType[0]), new RlpList(new RlpType[]{new RlpList(new RlpType[0])}), new RlpList(new RlpType[]{new RlpList(new RlpType[0]), new RlpList(new RlpType[]{new RlpList(new RlpType[0])})})})), (Matcher)CoreMatchers.is((Object)new byte[]{-57, -64, -63, -64, -61, -64, -63, -64}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((String)"Lorem ipsum dolor sit amet, consectetur adipisicing elit")), (Matcher)CoreMatchers.is((Object)new byte[]{-72, 56, 76, 111, 114, 101, 109, 32, 105, 112, 115, 117, 109, 32, 100, 111, 108, 111, 114, 32, 115, 105, 116, 32, 97, 109, 101, 116, 44, 32, 99, 111, 110, 115, 101, 99, 116, 101, 116, 117, 114, 32, 97, 100, 105, 112, 105, 115, 105, 99, 105, 110, 103, 32, 101, 108, 105, 116}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((BigInteger)BigInteger.ZERO)), (Matcher)CoreMatchers.is((Object)new byte[]{-128}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)RlpString.create((byte[])new byte[]{0})), (Matcher)CoreMatchers.is((Object)new byte[]{0}));
        Assert.assertThat((Object)RlpEncoder.encode((RlpType)new RlpList(new RlpType[]{RlpString.create((String)"zw"), new RlpList(new RlpType[]{RlpString.create((long)4L)}), RlpString.create((long)1L)})), (Matcher)CoreMatchers.is((Object)new byte[]{-58, -126, 122, 119, -63, 4, 1}));
    }
}

