/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.utils;

import java.math.BigDecimal;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.nervos.appchain.utils.Convert;

public class ConvertTest {
    @Test
    public void testFromWei() {
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.WEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000000")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.KWEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.MWEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.GWEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.SZABO), (Matcher)CoreMatchers.is((Object)new BigDecimal("21")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.FINNEY), (Matcher)CoreMatchers.is((Object)new BigDecimal("0.021")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.ETHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("0.000021")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.KETHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("0.000000021")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.METHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("0.000000000021")));
        MatcherAssert.assertThat((Object)Convert.fromWei((String)"21000000000000", (Convert.Unit)Convert.Unit.GETHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("0.000000000000021")));
    }

    @Test
    public void testToWei() {
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.WEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.KWEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.MWEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.GWEI), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.SZABO), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.FINNEY), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000000000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.ETHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000000000000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.KETHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000000000000000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.METHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000000000000000000")));
        MatcherAssert.assertThat((Object)Convert.toWei((String)"21", (Convert.Unit)Convert.Unit.GETHER), (Matcher)CoreMatchers.is((Object)new BigDecimal("21000000000000000000000000000")));
    }

    @Test
    public void testUnit() {
        MatcherAssert.assertThat((Object)Convert.Unit.fromString((String)"ether"), (Matcher)CoreMatchers.is((Object)Convert.Unit.ETHER));
        MatcherAssert.assertThat((Object)Convert.Unit.fromString((String)"ETHER"), (Matcher)CoreMatchers.is((Object)Convert.Unit.ETHER));
        MatcherAssert.assertThat((Object)Convert.Unit.fromString((String)"wei"), (Matcher)CoreMatchers.is((Object)Convert.Unit.WEI));
    }
}

