/*
 * Decompiled with CFR 0.152.
 */
package org.nervos.appchain.utils;

import java.util.Collections;
import java.util.List;
import org.nervos.appchain.utils.Numeric;

public class Strings {
    private Strings() {
    }

    public static String toCsv(List<String> src) {
        return Strings.join(src, ", ");
    }

    public static String join(List<String> src, String delimiter) {
        if (src != null) {
            StringBuilder builder = new StringBuilder();
            if (!src.isEmpty()) {
                builder.append(src.get(0));
            }
            for (int i = 1; i < src.size(); ++i) {
                builder.append(delimiter).append(src.get(i));
            }
            return builder.toString();
        }
        return null;
    }

    public static String capitaliseFirstLetter(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String lowercaseFirstLetter(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String zeros(int n) {
        return Strings.repeat('0', n);
    }

    public static String repeat(char value, int n) {
        return new String(new char[n]).replace("\u0000", String.valueOf(value));
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static byte[] asciiToHex(String asciiValue, int length) {
        char[] chars = asciiValue.toCharArray();
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            hex.append(Integer.toHexString(chars[i]));
        }
        String temp = "";
        for (String s : Collections.nCopies(length - hex.length() / 2, "00")) {
            temp = temp + s;
        }
        String hexStr = hex.toString() + temp;
        return Numeric.hexStringToByteArray(hexStr);
    }

    public static String hexStringToAscii(String hexStr) {
        String str;
        assert (hexStr.length() % 2 == 0);
        StringBuilder asciiStr = new StringBuilder();
        for (int i = 0; i < hexStr.length() && !(str = hexStr.substring(i, i + 2)).equals("00"); i += 2) {
            asciiStr.append((char)Integer.parseInt(str, 16));
        }
        return asciiStr.toString();
    }
}

