/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver;

import java.util.concurrent.ScheduledExecutorService;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.property.NextRTCProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.concurrent.ScheduledExecutorFactoryBean;

@Configuration
@ComponentScan(basePackageClasses={NextRTCConfig.class})
public class NextRTCConfig {
    @Autowired
    private NextRTCProperties properties;

    @Bean(name={"nextRTCEventBus"})
    public NextRTCEventBus eventBus() {
        return new NextRTCEventBus();
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        PropertySourcesPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertyPlaceholderConfigurer.setLocation((Resource)new ClassPathResource("nextrtc.properties"));
        return propertyPlaceholderConfigurer;
    }

    @Bean(name={"nextRTCPingScheduler"})
    public ScheduledExecutorService scheduler() {
        ScheduledExecutorFactoryBean factoryBean = new ScheduledExecutorFactoryBean();
        factoryBean.setThreadNamePrefix("NextRTCConfig");
        factoryBean.setPoolSize(this.properties.getSchedulerPoolSize());
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }
}

