/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.api;

import com.google.common.eventbus.EventBus;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.api.dto.NextRTCEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="nextRTCEventBus")
@Scope(value="singleton")
public class NextRTCEventBus {
    private static final Logger log = LoggerFactory.getLogger(NextRTCEventBus.class);
    private EventBus eventBus = new EventBus();

    public void post(NextRTCEvent event) {
        if (event.type() != NextRTCEvents.MESSAGE) {
            log.info("POSTED EVENT: " + event);
        }
        this.eventBus.post((Object)event);
    }

    @Deprecated
    public void post(Object o) {
        this.eventBus.post(o);
    }

    public void register(Object listeners) {
        log.info("REGISTERED LISTENER: " + listeners);
        this.eventBus.register(listeners);
    }
}

