/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.util.function.Function;
import org.apache.commons.lang3.StringEscapeUtils;
import org.nextrtc.signalingserver.api.ConfigurationBuilder;
import org.nextrtc.signalingserver.api.EndpointConfiguration;
import org.nextrtc.signalingserver.domain.Connection;
import org.nextrtc.signalingserver.domain.Message;

public interface NextRTCServer
extends Closeable {
    public void register(Connection var1);

    public void handle(Message var1, Connection var2);

    default public void handle(String message, Connection connection) {
        Message decode;
        try {
            decode = MessageDecoder.decode(message);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.handle(decode, connection);
    }

    public void unregister(Connection var1, String var2);

    public void handleError(Connection var1, Throwable var2);

    public static NextRTCServer create(Function<EndpointConfiguration, EndpointConfiguration> function) {
        return function.apply(new ConfigurationBuilder().createDefaultEndpoint()).nextRTCServer();
    }

    public static class MessageEncoder {
        private static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

        public static String encode(Object json) {
            return gson.toJson(json);
        }
    }

    public static class MessageDecoder {
        private static Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

        public static Message decode(String json) {
            return (Message)gson.fromJson(StringEscapeUtils.escapeHtml4((String)json.replace("\"", "'")), Message.class);
        }
    }
}

