/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.cases;

import javax.inject.Inject;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.cases.SignalHandler;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.exception.Exceptions;
import org.nextrtc.signalingserver.exception.SignalingException;
import org.nextrtc.signalingserver.factory.ConversationFactory;
import org.nextrtc.signalingserver.repository.ConversationRepository;
import org.springframework.stereotype.Component;

@Component(value="nextRTC_CREATE")
public class CreateConversation
implements SignalHandler {
    private NextRTCEventBus eventBus;
    private ConversationRepository conversations;
    private ConversationFactory factory;

    @Inject
    public CreateConversation(NextRTCEventBus eventBus, ConversationRepository conversations, ConversationFactory factory) {
        this.eventBus = eventBus;
        this.conversations = conversations;
        this.factory = factory;
    }

    @Override
    public synchronized void execute(InternalMessage context) {
        this.conversations.findBy(context.getFrom()).map(Conversation::getId).map(Exceptions.MEMBER_IN_OTHER_CONVERSATION::exception).ifPresent(SignalingException::throwException);
        String id = context.getContent();
        Conversation conversation = this.conversations.save(this.factory.create(id, context.getCustom().get("type")));
        this.eventBus.post(NextRTCEvents.CONVERSATION_CREATED.basedOn(context, conversation));
        conversation.join(context.getFrom());
    }
}

