/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.cases;

import java.util.Optional;
import javax.inject.Inject;
import org.nextrtc.signalingserver.cases.CreateConversation;
import org.nextrtc.signalingserver.cases.SignalHandler;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.exception.Exceptions;
import org.nextrtc.signalingserver.exception.SignalingException;
import org.nextrtc.signalingserver.property.NextRTCProperties;
import org.nextrtc.signalingserver.repository.ConversationRepository;
import org.springframework.stereotype.Component;

@Component(value="nextRTC_JOIN")
public class JoinConversation
implements SignalHandler {
    private ConversationRepository conversations;
    private CreateConversation createConversation;
    private NextRTCProperties properties;

    @Inject
    public JoinConversation(ConversationRepository conversations, CreateConversation createConversation, NextRTCProperties properties) {
        this.conversations = conversations;
        this.createConversation = createConversation;
        this.properties = properties;
    }

    @Override
    public synchronized void execute(InternalMessage context) {
        this.conversations.findBy(context.getFrom()).map(Conversation::getId).map(Exceptions.MEMBER_IN_OTHER_CONVERSATION::exception).ifPresent(SignalingException::throwException);
        Optional<Conversation> conversation = this.findConversationToJoin(context);
        if (conversation.isPresent()) {
            conversation.get().join(context.getFrom());
        } else {
            if (this.properties.isJoinOnlyToExisting()) {
                throw Exceptions.CONVERSATION_NOT_FOUND.exception();
            }
            this.createConversation.execute(context);
        }
    }

    private Optional<Conversation> findConversationToJoin(InternalMessage message) {
        return this.conversations.findBy(message.getContent());
    }
}

