/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.cases;

import java.util.Optional;
import javax.inject.Inject;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.cases.SignalHandler;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.EventContext;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.exception.Exceptions;
import org.nextrtc.signalingserver.repository.ConversationRepository;
import org.springframework.stereotype.Component;

@Component(value="nextRTC_LEFT")
public class LeftConversation
implements SignalHandler {
    private NextRTCEventBus eventBus;
    private ConversationRepository conversations;

    @Inject
    public LeftConversation(NextRTCEventBus eventBus, ConversationRepository conversations) {
        this.eventBus = eventBus;
        this.conversations = conversations;
    }

    @Override
    public void execute(InternalMessage context) {
        Member leaving = context.getFrom();
        Conversation conversation = this.checkPrecondition(leaving.getConversation());
        conversation.left(leaving);
    }

    public void destroy(Conversation toRemove, Member last) {
        this.eventBus.post(NextRTCEvents.CONVERSATION_DESTROYED.basedOn(EventContext.builder().conversation(this.conversations.remove(toRemove.getId())).from(last)));
    }

    private Conversation checkPrecondition(Optional<Conversation> conversation) {
        if (!conversation.isPresent()) {
            throw Exceptions.CONVERSATION_NOT_FOUND.exception();
        }
        return conversation.get();
    }
}

