/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.cases;

import javax.inject.Inject;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.cases.SignalHandler;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.springframework.stereotype.Component;

@Component(value="nextRTC_TEXT")
public class TextMessage
implements SignalHandler {
    private NextRTCEventBus eventBus;
    private MessageSender sender;

    @Inject
    public TextMessage(NextRTCEventBus eventBus, MessageSender sender) {
        this.eventBus = eventBus;
        this.sender = sender;
    }

    @Override
    public void execute(InternalMessage message) {
        Member from = message.getFrom();
        if (message.getTo() == null && from.getConversation().isPresent()) {
            Conversation conversation = from.getConversation().get();
            conversation.broadcast(from, message);
            this.eventBus.post(NextRTCEvents.TEXT.basedOn(message));
        } else if (from.hasSameConversation(message.getTo())) {
            this.sender.send(message);
            this.eventBus.post(NextRTCEvents.TEXT.basedOn(message));
        }
    }
}

