/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.cases.connection;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.cases.connection.ConnectionState;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.Signal;
import org.nextrtc.signalingserver.property.NextRTCProperties;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ConnectionContext {
    private ConnectionState state = ConnectionState.NOT_INITIALIZED;
    private ZonedDateTime lastUpdated = ZonedDateTime.now();
    private NextRTCProperties properties;
    private NextRTCEventBus bus;
    private MessageSender sender;
    private Member master;
    private Member slave;
    private List<InternalMessage> candidates = new ArrayList<InternalMessage>();

    public ConnectionContext(Member master, Member slave) {
        this.master = master;
        this.slave = slave;
    }

    public void process(InternalMessage message) {
        if (message.getSignal() == Signal.CANDIDATE && !this.is(message, ConnectionState.EXCHANGE_CANDIDATES)) {
            this.recordCandidate(message);
        }
        if (this.is(message, ConnectionState.OFFER_REQUESTED)) {
            this.setState(ConnectionState.ANSWER_REQUESTED);
            this.answerRequest(message);
        } else if (this.is(message, ConnectionState.ANSWER_REQUESTED)) {
            this.setState(ConnectionState.EXCHANGE_CANDIDATES);
            this.finalize(message);
            this.sendCollectedCandidates();
        } else if (this.is(message, ConnectionState.EXCHANGE_CANDIDATES)) {
            this.exchangeCandidates(message);
        }
    }

    private void sendCollectedCandidates() {
        this.candidates.forEach(this::exchangeCandidates);
        this.candidates.clear();
    }

    private void recordCandidate(InternalMessage message) {
        this.candidates.add(message);
    }

    private void exchangeCandidates(InternalMessage message) {
        this.sender.send(message.copy().signal(Signal.CANDIDATE).build());
    }

    private void finalize(InternalMessage message) {
        this.sender.send(message.copy().from(this.slave).to(this.master).signal(Signal.FINALIZE).build());
        this.bus.post(NextRTCEvents.MEDIA_LOCAL_STREAM_CREATED.occurFor(this.slave.getConnection()));
        this.bus.post(NextRTCEvents.MEDIA_STREAMING.occurFor(this.master.getConnection()));
        this.bus.post(NextRTCEvents.MEDIA_STREAMING.occurFor(this.slave.getConnection()));
    }

    private void answerRequest(InternalMessage message) {
        this.bus.post(NextRTCEvents.MEDIA_LOCAL_STREAM_CREATED.occurFor(this.master.getConnection()));
        this.sender.send(message.copy().from(this.master).to(this.slave).signal(Signal.ANSWER_REQUEST).build());
        this.bus.post(NextRTCEvents.MEDIA_LOCAL_STREAM_REQUESTED.occurFor(this.slave.getConnection()));
    }

    private boolean is(InternalMessage message, ConnectionState state) {
        return state.equals((Object)this.state) && state.isValid(message);
    }

    public void begin() {
        this.setState(ConnectionState.OFFER_REQUESTED);
        this.sender.send(InternalMessage.create().from(this.slave).to(this.master).signal(Signal.OFFER_REQUEST).build());
        this.bus.post(NextRTCEvents.MEDIA_LOCAL_STREAM_REQUESTED.occurFor(this.master.getConnection()));
    }

    public boolean isCurrent() {
        return this.lastUpdated.plusSeconds(this.properties.getMaxConnectionSetupTime()).isAfter(ZonedDateTime.now());
    }

    private void setState(ConnectionState state) {
        this.state = state;
        this.lastUpdated = ZonedDateTime.now();
    }

    @Inject
    public void setBus(NextRTCEventBus bus) {
        this.bus = bus;
    }

    @Inject
    public void setProperties(NextRTCProperties properties) {
        this.properties = properties;
    }

    @Inject
    public void setSender(MessageSender sender) {
        this.sender = sender;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public ZonedDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public NextRTCProperties getProperties() {
        return this.properties;
    }

    public NextRTCEventBus getBus() {
        return this.bus;
    }

    public MessageSender getSender() {
        return this.sender;
    }

    public Member getMaster() {
        return this.master;
    }

    public Member getSlave() {
        return this.slave;
    }

    public List<InternalMessage> getCandidates() {
        return this.candidates;
    }
}

