/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import org.nextrtc.signalingserver.domain.RTCConnections;
import org.nextrtc.signalingserver.repository.ConversationRepository;
import org.nextrtc.signalingserver.repository.MemberRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class CloseableContext
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(CloseableContext.class);
    private final ScheduledExecutorService scheduler;
    private final RTCConnections connections;
    private final MemberRepository members;
    private final ConversationRepository conversations;

    @Inject
    public CloseableContext(ScheduledExecutorService scheduler, RTCConnections connections, MemberRepository members, ConversationRepository conversations) {
        this.scheduler = scheduler;
        this.connections = connections;
        this.members = members;
        this.conversations = conversations;
    }

    @Override
    public void close() throws IOException {
        this.scheduler.shutdownNow();
        this.closeQuietly(this.conversations);
        this.closeQuietly(this.members);
        this.closeQuietly(this.connections);
    }

    private void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            log.error("Problem during closing " + closeable, (Throwable)e);
        }
    }
}

