/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.nextrtc.signalingserver.api.dto.NextRTCConversation;
import org.nextrtc.signalingserver.cases.LeftConversation;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.Signal;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public abstract class Conversation
implements NextRTCConversation {
    protected static final ExecutorService parallel = Executors.newCachedThreadPool();
    protected final String id;
    private LeftConversation leftConversation;
    protected MessageSender messageSender;

    public Conversation(String id) {
        this.id = id;
    }

    public Conversation(String id, LeftConversation leftConversation, MessageSender messageSender) {
        this.id = id;
        this.leftConversation = leftConversation;
        this.messageSender = messageSender;
    }

    public abstract void join(Member var1);

    public synchronized void left(Member sender) {
        if (this.remove(sender) && this.isWithoutMember()) {
            this.leftConversation.destroy(this, sender);
        }
    }

    protected abstract boolean remove(Member var1);

    protected void assignSenderToConversation(Member sender) {
        sender.assign(this);
    }

    public abstract boolean isWithoutMember();

    public abstract boolean has(Member var1);

    public abstract void exchangeSignals(InternalMessage var1);

    protected void sendJoinedToConversation(Member sender, String id) {
        this.messageSender.send(InternalMessage.create().to(sender).content(id).signal(Signal.JOINED).build());
    }

    protected void sendJoinedFrom(Member sender, Member member) {
        this.messageSender.send(InternalMessage.create().from(sender).to(member).signal(Signal.NEW_JOINED).content(sender.getId()).build());
    }

    protected void sendLeftMessage(Member leaving, Member recipient) {
        this.messageSender.send(InternalMessage.create().from(leaving).to(recipient).signal(Signal.LEFT).build());
    }

    public abstract void broadcast(Member var1, InternalMessage var2);

    @Inject
    public void setLeftConversation(LeftConversation leftConversation) {
        this.leftConversation = leftConversation;
    }

    @Inject
    public void setMessageSender(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public LeftConversation getLeftConversation() {
        return this.leftConversation;
    }

    public MessageSender getMessageSender() {
        return this.messageSender;
    }
}

