/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import javax.inject.Inject;
import org.nextrtc.signalingserver.domain.Connection;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.Signal;
import org.nextrtc.signalingserver.repository.MemberRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class DefaultMessageSender
implements MessageSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageSender.class);
    private MemberRepository members;

    @Inject
    public DefaultMessageSender(MemberRepository members) {
        this.members = members;
    }

    @Override
    public void send(InternalMessage message) {
        this.send(message, 3);
    }

    private void send(InternalMessage message, int retry) {
        if (message.getSignal() != Signal.PING) {
            log.debug("Outgoing: " + message.transformToExternalMessage());
        }
        if (message.getSignal() == Signal.ERROR) {
            this.tryToSendErrorMessage(message);
            return;
        }
        Member destination = message.getTo();
        if (destination == null || !destination.getConnection().isOpen()) {
            log.warn("Destination member is not set or session is closed! Message will not be send: " + message.transformToExternalMessage());
            return;
        }
        this.members.findBy(destination.getId()).ifPresent(member -> this.lockAndRun(message, (Member)member, retry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToSendErrorMessage(InternalMessage message) {
        try {
            Connection connection;
            Connection connection2 = connection = message.getTo().getConnection();
            synchronized (connection2) {
                connection.sendObject(message.transformToExternalMessage());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to send message: " + message.transformToExternalMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockAndRun(InternalMessage message, Member destination, int retry) {
        try {
            Connection connection = destination.getConnection();
            Member member = destination;
            synchronized (member) {
                connection.sendObject(message.transformToExternalMessage());
            }
        }
        catch (Exception e) {
            if (retry >= 0) {
                log.warn("Retrying... " + message.transformToExternalMessage());
                this.send(message, --retry);
            }
            log.error("Unable to send message: " + message.transformToExternalMessage() + " error during sending!");
            throw new RuntimeException("Unable to send message: " + message.transformToExternalMessage(), e);
        }
    }
}

