/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import com.google.common.collect.Maps;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.api.dto.NextRTCConversation;
import org.nextrtc.signalingserver.api.dto.NextRTCEvent;
import org.nextrtc.signalingserver.api.dto.NextRTCMember;
import org.nextrtc.signalingserver.exception.SignalingException;

public class EventContext
implements NextRTCEvent {
    private final NextRTCEvents type;
    private final ZonedDateTime published = ZonedDateTime.now();
    private final Map<String, String> custom = Maps.newHashMap();
    private final NextRTCMember from;
    private final NextRTCMember to;
    private final NextRTCConversation conversation;
    private final SignalingException exception;
    private final String content;

    private EventContext(NextRTCEvents type, NextRTCMember from, NextRTCMember to, NextRTCConversation conversation, SignalingException exception, String content) {
        this.type = type;
        this.from = from;
        this.to = to;
        this.conversation = conversation;
        this.exception = exception;
        this.content = content;
    }

    @Override
    public NextRTCEvents type() {
        return this.type;
    }

    @Override
    public ZonedDateTime published() {
        return this.published;
    }

    @Override
    public Optional<NextRTCMember> from() {
        return Optional.ofNullable(this.from);
    }

    @Override
    public Optional<NextRTCMember> to() {
        return Optional.ofNullable(this.to);
    }

    @Override
    public Optional<NextRTCConversation> conversation() {
        return Optional.ofNullable(this.conversation);
    }

    @Override
    public Optional<SignalingException> exception() {
        return Optional.ofNullable(this.exception);
    }

    @Override
    public Map<String, String> custom() {
        return Collections.unmodifiableMap(this.custom);
    }

    @Override
    public String content() {
        return StringUtils.defaultString((String)this.content);
    }

    public String toString() {
        return String.format("%s (%s -> %s) | conv: %s | %s", new Object[]{this.type, this.from, this.to, this.conversation, this.custom});
    }

    public static EventContextBuilder builder() {
        return new EventContextBuilder();
    }

    public static class EventContextBuilder {
        private Map<String, String> custom;
        private NextRTCEvents type;
        private NextRTCMember from;
        private NextRTCMember to;
        private NextRTCConversation conversation;
        private SignalingException exception;
        private String content;

        public EventContextBuilder content(String content) {
            this.content = content;
            return this;
        }

        public EventContextBuilder type(NextRTCEvents type) {
            this.type = type;
            return this;
        }

        public EventContextBuilder custom(Map<String, String> custom) {
            this.custom = custom;
            return this;
        }

        public EventContextBuilder from(NextRTCMember from) {
            this.from = from;
            return this;
        }

        public EventContextBuilder to(NextRTCMember to) {
            this.to = to;
            return this;
        }

        public EventContextBuilder conversation(NextRTCConversation conversation) {
            this.conversation = conversation;
            return this;
        }

        public EventContextBuilder exception(SignalingException exception) {
            this.exception = exception;
            return this;
        }

        public NextRTCEvent build() {
            if (this.type == null) {
                throw new IllegalArgumentException("Type is required");
            }
            EventContext eventContext = new EventContext(this.type, this.from, this.to, this.conversation, this.exception, this.content);
            if (this.custom != null) {
                eventContext.custom.putAll(this.custom);
            }
            return eventContext;
        }
    }
}

