/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.Message;
import org.nextrtc.signalingserver.domain.Signal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalMessage {
    private static final Logger log = LoggerFactory.getLogger(InternalMessage.class);
    private Member from;
    private Member to;
    private Signal signal;
    private String content;
    private Map<String, String> custom = Maps.newHashMap();

    private InternalMessage(Member from, Member to, Signal signal, String content, Map<String, String> custom) {
        this.from = from;
        this.to = to;
        this.signal = signal;
        this.content = content;
        if (custom != null) {
            this.custom.putAll(custom);
        }
    }

    public static InternalMessageBuilder create() {
        return new InternalMessageBuilder();
    }

    public InternalMessageBuilder copy() {
        return new InternalMessageBuilder().from(this.from).to(this.to).content(this.content).custom(this.custom).signal(this.signal);
    }

    public Message transformToExternalMessage() {
        return Message.create().from(this.fromNullable(this.from)).to(this.fromNullable(this.to)).signal(this.signal.ordinaryName()).content(StringUtils.defaultString((String)this.content)).custom(this.custom).build();
    }

    private String fromNullable(Member member) {
        return member == null ? "" : member.getId();
    }

    public String toString() {
        return String.format("(%s -> %s)[%s]: %s |%s", this.from, this.to, this.signal != null ? this.signal.ordinaryName() : null, this.content, this.custom);
    }

    public Member getFrom() {
        return this.from;
    }

    public Member getTo() {
        return this.to;
    }

    public Signal getSignal() {
        return this.signal;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, String> getCustom() {
        return this.custom;
    }

    public static class InternalMessageBuilder {
        private Member from;
        private Member to;
        private Signal signal;
        private String content;
        private Map<String, String> custom = Maps.newHashMap();

        InternalMessageBuilder() {
        }

        public InternalMessageBuilder from(Member from) {
            this.from = from;
            return this;
        }

        public InternalMessageBuilder to(Member to) {
            this.to = to;
            return this;
        }

        public InternalMessageBuilder signal(Signal signal) {
            this.signal = signal;
            return this;
        }

        public InternalMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public InternalMessageBuilder custom(Map<String, String> custom) {
            if (custom != null) {
                this.custom.putAll(custom);
            }
            return this;
        }

        public InternalMessageBuilder addCustom(String key, String value) {
            this.custom.put(key, value);
            return this;
        }

        public InternalMessage build() {
            return new InternalMessage(this.from, this.to, this.signal, this.content, this.custom);
        }

        public String toString() {
            return "InternalMessageBuilder(from=" + this.from + ", to=" + this.to + ", signal=" + this.signal + ", content=" + this.content + ", custom=" + this.custom + ")";
        }
    }
}

