/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.api.dto.NextRTCMember;
import org.nextrtc.signalingserver.domain.Connection;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.EventContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class Member
implements NextRTCMember {
    private String id;
    private Connection connection;
    private Conversation conversation;
    private NextRTCEventBus eventBus;
    private ScheduledFuture<?> ping;

    public Member(Connection connection, ScheduledFuture<?> ping) {
        this.id = connection.getId();
        this.connection = connection;
        this.ping = ping;
    }

    public Optional<Conversation> getConversation() {
        return Optional.ofNullable(this.conversation);
    }

    public void markLeft() {
        this.ping.cancel(true);
    }

    void assign(Conversation conversation) {
        this.conversation = conversation;
        this.eventBus.post(NextRTCEvents.MEMBER_JOINED.basedOn(EventContext.builder().conversation(conversation).from(this)));
    }

    public void unassignConversation(Conversation conversation) {
        this.eventBus.post(NextRTCEvents.MEMBER_LEFT.basedOn(EventContext.builder().conversation(conversation).from(this)));
        this.conversation = null;
    }

    public boolean hasSameConversation(Member to) {
        return to != null && this.conversation.equals(to.conversation);
    }

    @Inject
    public void setEventBus(NextRTCEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public String toString() {
        return String.format("%s", this.id);
    }

    @Override
    public synchronized Connection getConnection() {
        return this.connection;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Member)) {
            return false;
        }
        Member m = (Member)o;
        return new EqualsBuilder().append((Object)m.id, (Object)this.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).build();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public NextRTCEventBus getEventBus() {
        return this.eventBus;
    }

    public ScheduledFuture<?> getPing() {
        return this.ping;
    }
}

