/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import com.google.common.collect.Maps;
import com.google.gson.annotations.Expose;
import java.beans.ConstructorProperties;
import java.util.Map;

public class Message {
    @Expose
    private String from = "";
    @Expose
    private String to = "";
    @Expose
    private String signal = "";
    @Expose
    private String content = "";
    @Expose
    private Map<String, String> custom = Maps.newHashMap();

    @Deprecated
    Message() {
    }

    public String toString() {
        return String.format("(%s -> %s)[%s]: %s |%s", this.from, this.to, this.signal, this.content, this.custom);
    }

    public static MessageBuilder create() {
        return new MessageBuilder();
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getSignal() {
        return this.signal;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, String> getCustom() {
        return this.custom;
    }

    @ConstructorProperties(value={"from", "to", "signal", "content", "custom"})
    private Message(String from, String to, String signal, String content, Map<String, String> custom) {
        this.from = from;
        this.to = to;
        this.signal = signal;
        this.content = content;
        this.custom = custom;
    }

    public static class MessageBuilder {
        private String from;
        private String to;
        private String signal;
        private String content;
        private Map<String, String> custom;

        MessageBuilder() {
        }

        public MessageBuilder from(String from) {
            this.from = from;
            return this;
        }

        public MessageBuilder to(String to) {
            this.to = to;
            return this;
        }

        public MessageBuilder signal(String signal) {
            this.signal = signal;
            return this;
        }

        public MessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public MessageBuilder custom(Map<String, String> custom) {
            this.custom = custom;
            return this;
        }

        public Message build() {
            return new Message(this.from, this.to, this.signal, this.content, this.custom);
        }

        public String toString() {
            return "Message.MessageBuilder(from=" + this.from + ", to=" + this.to + ", signal=" + this.signal + ", content=" + this.content + ", custom=" + this.custom + ")";
        }
    }
}

