/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.nextrtc.signalingserver.cases.connection.ConnectionContext;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.property.NextRTCProperties;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class RTCConnections
implements Closeable {
    private static Table<Member, Member, ConnectionContext> connections = HashBasedTable.create();
    private ScheduledExecutorService scheduler;
    private NextRTCProperties properties;

    @Inject
    public RTCConnections(ScheduledExecutorService scheduler, NextRTCProperties properties) {
        this.scheduler = scheduler;
        this.properties = properties;
    }

    @PostConstruct
    void cleanOldConnections() {
        this.scheduler.scheduleWithFixedDelay(this::removeOldConnections, this.properties.getMaxConnectionSetupTime(), this.properties.getMaxConnectionSetupTime(), TimeUnit.SECONDS);
    }

    void removeOldConnections() {
        List<ConnectionContext> oldConnections = connections.values().stream().filter(context -> !context.isCurrent()).collect(Collectors.toList());
        oldConnections.forEach(c -> {
            ConnectionContext cfr_ignored_0 = (ConnectionContext)connections.remove((Object)c.getMaster(), (Object)c.getSlave());
        });
    }

    public void put(Member from, Member to, ConnectionContext ctx) {
        connections.put((Object)from, (Object)to, (Object)ctx);
        connections.put((Object)to, (Object)from, (Object)ctx);
    }

    public Optional<ConnectionContext> get(Member from, Member to) {
        return Optional.ofNullable(connections.get((Object)from, (Object)to));
    }

    @Override
    public void close() throws IOException {
        connections.clear();
    }
}

