/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.api.NextRTCServer;
import org.nextrtc.signalingserver.cases.RegisterMember;
import org.nextrtc.signalingserver.cases.SignalHandler;
import org.nextrtc.signalingserver.domain.CloseableContext;
import org.nextrtc.signalingserver.domain.Connection;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.Message;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.Signal;
import org.nextrtc.signalingserver.domain.SignalResolver;
import org.nextrtc.signalingserver.exception.Exceptions;
import org.nextrtc.signalingserver.exception.SignalingException;
import org.nextrtc.signalingserver.repository.MemberRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Server
implements NextRTCServer {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private final CloseableContext context;
    private final NextRTCEventBus eventBus;
    private final MemberRepository members;
    private final SignalResolver resolver;
    private final RegisterMember register;
    private final MessageSender sender;

    @Inject
    public Server(NextRTCEventBus eventBus, MemberRepository members, SignalResolver resolver, RegisterMember register, MessageSender sender, CloseableContext context) {
        this.eventBus = eventBus;
        this.members = members;
        this.resolver = resolver;
        this.register = register;
        this.sender = sender;
        this.context = context;
    }

    @Override
    public void register(Connection s) {
        this.doSaveExecution(s, session -> this.register.incoming((Connection)session));
    }

    @Override
    public void handle(Message external, Connection s) {
        this.doSaveExecution(s, session -> {
            Pair<Signal, SignalHandler> resolve = this.resolver.resolve(external.getSignal());
            InternalMessage internalMessage = this.buildInternalMessage(external, (Signal)resolve.getKey(), (Connection)session);
            this.eventBus.post(NextRTCEvents.MESSAGE.basedOn(internalMessage));
            this.processMessage((SignalHandler)resolve.getValue(), internalMessage);
        });
    }

    private void processMessage(SignalHandler handler, InternalMessage message) {
        log.debug("Incoming: " + message);
        if (handler != null) {
            handler.execute(message);
        }
    }

    private InternalMessage buildInternalMessage(Message message, Signal signal, Connection connection) {
        InternalMessage.InternalMessageBuilder bld = InternalMessage.create().from(this.findMember(connection)).content(message.getContent()).signal(signal).custom(message.getCustom());
        this.members.findBy(message.getTo()).ifPresent(bld::to);
        return bld.build();
    }

    private Member findMember(Connection connection) {
        return this.members.findBy(connection.getId()).orElseThrow(() -> new SignalingException(Exceptions.MEMBER_NOT_FOUND));
    }

    @Override
    public void unregister(Connection connection, String reason) {
        this.doSaveExecution(connection, session -> {
            this.members.unregister(session.getId());
            this.eventBus.post(NextRTCEvents.SESSION_CLOSED.occurFor((Connection)session, reason));
        });
    }

    @Override
    public void handleError(Connection connection, Throwable exception) {
        this.doSaveExecution(connection, session -> {
            this.members.unregister(session.getId());
            this.eventBus.post(NextRTCEvents.UNEXPECTED_SITUATION.occurFor((Connection)session, exception.getMessage()));
        });
    }

    private void doSaveExecution(Connection connection, Consumer<Connection> action) {
        try {
            action.accept(connection);
        }
        catch (Exception e) {
            log.warn("Server will try to handle this exception and send information as normal message through websocket", (Throwable)e);
            this.sendErrorOverWebSocket(connection, e);
        }
    }

    private void sendErrorOverWebSocket(Connection session, Exception e) {
        try {
            this.sender.send(InternalMessage.create().to(new Member(session, null)).signal(Signal.ERROR).content(e.getMessage()).addCustom("stackTrace", this.writeStackTraceToString(e)).build());
        }
        catch (Exception resendException) {
            log.error("Something goes wrong during resend! Exception omitted", (Throwable)resendException);
        }
    }

    private String writeStackTraceToString(Exception e) {
        if (log.isDebugEnabled()) {
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            return errors.toString();
        }
        return e.getClass().getSimpleName() + " - " + e.getMessage();
    }

    @Override
    public void close() throws IOException {
        this.context.close();
    }
}

