/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Signal {
    public static final Signal EMPTY = new Signal("");
    public static final Signal OFFER_REQUEST = new Signal("offerRequest");
    public static final Signal OFFER_RESPONSE = new Signal("offerResponse", "nextRTC_OFFER_RESPONSE");
    public static final Signal ANSWER_REQUEST = new Signal("answerRequest");
    public static final Signal ANSWER_RESPONSE = new Signal("answerResponse", "nextRTC_ANSWER_RESPONSE");
    public static final Signal FINALIZE = new Signal("finalize");
    public static final Signal CANDIDATE = new Signal("candidate", "nextRTC_CANDIDATE");
    public static final Signal PING = new Signal("ping");
    public static final Signal LEFT = new Signal("left", "nextRTC_LEFT");
    public static final Signal JOIN = new Signal("join", "nextRTC_JOIN");
    public static final Signal CREATE = new Signal("create", "nextRTC_CREATE");
    public static final Signal JOINED = new Signal("joined");
    public static final Signal NEW_JOINED = new Signal("newJoined");
    public static final Signal CREATED = new Signal("created");
    public static final Signal TEXT = new Signal("text", "nextRTC_TEXT");
    public static final Signal ERROR = new Signal("error");
    public static final Signal END = new Signal("end");
    private static final Signal[] signals = new Signal[]{EMPTY, OFFER_REQUEST, OFFER_RESPONSE, ANSWER_REQUEST, ANSWER_RESPONSE, FINALIZE, CANDIDATE, PING, LEFT, JOIN, CREATE, JOINED, NEW_JOINED, CREATED, TEXT, ERROR, END};
    private final String signalName;
    private final String signalHandler;

    Signal(String signalName) {
        this(signalName, "nextRTC_EMPTY");
    }

    Signal(String signalName, String signalHandler) {
        this.signalName = signalName;
        this.signalHandler = signalHandler;
    }

    public boolean is(String string) {
        return this.ordinaryName().equalsIgnoreCase(string);
    }

    public boolean is(Signal signal) {
        return this.equals(signal);
    }

    public String ordinaryName() {
        return this.signalName;
    }

    public static Signal fromString(String string) {
        String signalName = StringUtils.defaultString((String)string);
        for (Signal existing : signals) {
            if (!existing.signalName.equalsIgnoreCase(signalName)) continue;
            return existing;
        }
        return new Signal(signalName);
    }

    public static Signal byHandlerName(String string) {
        String handlerName = StringUtils.defaultString((String)string);
        Optional<Signal> signal = Arrays.stream(signals).filter(s -> s.signalHandler.equals(handlerName)).findFirst();
        if (signal.isPresent()) {
            return signal.get();
        }
        for (Signal existing : signals) {
            if (!existing.signalName.equalsIgnoreCase(handlerName)) continue;
            return existing;
        }
        return EMPTY;
    }

    public static Signal[] values() {
        return signals;
    }

    public String toString() {
        return this.signalName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Signal)) {
            return false;
        }
        Signal that = (Signal)obj;
        return this.signalName.equalsIgnoreCase(that.signalName);
    }

    public int hashCode() {
        return this.signalName.hashCode();
    }
}

