/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain.conversation;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.nextrtc.signalingserver.api.dto.NextRTCMember;
import org.nextrtc.signalingserver.cases.ExchangeSignalsBetweenMembers;
import org.nextrtc.signalingserver.cases.LeftConversation;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.Signal;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public abstract class AbstractMeshConversation
extends Conversation {
    private ExchangeSignalsBetweenMembers exchange;
    private Set<Member> members = Sets.newConcurrentHashSet();
    private Member creator;

    @Override
    public Set<NextRTCMember> getMembers() {
        return Sets.newHashSet(this.members);
    }

    @Override
    public Member getCreator() {
        return this.creator;
    }

    protected Set<Member> members() {
        return Sets.newHashSet(this.members);
    }

    public AbstractMeshConversation(String id) {
        super(id);
    }

    public AbstractMeshConversation(String id, LeftConversation left, MessageSender sender, ExchangeSignalsBetweenMembers exchange) {
        super(id, left, sender);
        this.exchange = exchange;
    }

    public abstract String getTypeName();

    @Override
    public synchronized void join(Member sender) {
        this.assignSenderToConversation(sender);
        this.informSenderThatHasBeenJoined(sender);
        this.informRestAndBeginSignalExchange(sender);
        this.members.add(sender);
    }

    private void informRestAndBeginSignalExchange(Member sender) {
        for (Member to : this.members) {
            parallel.execute(() -> {
                this.sendJoinedFrom(sender, to);
                this.sendJoinedFrom(to, sender);
                this.exchange.begin(to, sender);
            });
        }
    }

    private void informSenderThatHasBeenJoined(Member sender) {
        if (this.isWithoutMember()) {
            this.creator = sender;
            this.sendJoinedToFirst(sender, this.id);
        } else {
            this.sendJoinedToConversation(sender, this.id);
        }
    }

    @Override
    public synchronized boolean isWithoutMember() {
        return this.members.isEmpty();
    }

    @Override
    public synchronized boolean has(Member member) {
        return member != null && this.members.contains(member);
    }

    @Override
    public void exchangeSignals(InternalMessage message) {
        this.exchange.execute(message);
    }

    @Override
    public void broadcast(Member from, InternalMessage message) {
        this.members.stream().filter(member -> !member.equals(from)).forEach(to -> this.messageSender.send(message.copy().from(from).to((Member)to).build()));
    }

    @Override
    public synchronized boolean remove(Member leaving) {
        boolean remove = this.members.remove(leaving);
        if (remove) {
            leaving.unassignConversation(this);
            for (Member member : this.members) {
                parallel.execute(() -> this.sendLeftMessage(leaving, member));
            }
        }
        if (this.members.isEmpty()) {
            this.creator = null;
        }
        return remove;
    }

    private void sendJoinedToFirst(Member sender, String id) {
        this.messageSender.send(InternalMessage.create().to(sender).signal(Signal.CREATED).addCustom("type", "MESH").content(id).build());
    }

    @Override
    public void close() throws IOException {
        this.members.parallelStream().forEach(this::remove);
    }

    @Inject
    public void setExchange(ExchangeSignalsBetweenMembers exchange) {
        this.exchange = exchange;
    }
}

