/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain.conversation;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.nextrtc.signalingserver.api.dto.NextRTCMember;
import org.nextrtc.signalingserver.cases.ExchangeSignalsBetweenMembers;
import org.nextrtc.signalingserver.cases.LeftConversation;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.InternalMessage;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.Signal;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BroadcastConversation
extends Conversation {
    private ExchangeSignalsBetweenMembers exchange;
    private Member broadcaster;
    private Set<Member> audience = Sets.newConcurrentHashSet();

    public BroadcastConversation(String id) {
        super(id);
    }

    public BroadcastConversation(String id, LeftConversation left, MessageSender sender, ExchangeSignalsBetweenMembers exchange) {
        super(id, left, sender);
        this.exchange = exchange;
    }

    @Override
    public synchronized void join(Member sender) {
        this.assignSenderToConversation(sender);
        this.informSenderThatHasBeenJoined(sender);
        this.beginSignalExchangeBetweenBroadcasterAndNewAudience(sender);
        if (!this.broadcaster.equals(sender)) {
            this.audience.add(sender);
        }
    }

    @Override
    public synchronized boolean remove(Member leaving) {
        if (this.broadcaster.equals(leaving)) {
            for (Member member : this.audience) {
                this.sendLeftMessage(this.broadcaster, member);
                this.sendEndMessage(this.broadcaster, member);
                member.unassignConversation(this);
            }
            this.audience.clear();
            this.broadcaster.unassignConversation(this);
            this.broadcaster = null;
            return true;
        }
        this.sendLeftMessage(leaving, this.broadcaster);
        boolean remove = this.audience.remove(leaving);
        if (remove) {
            leaving.unassignConversation(this);
        }
        return remove;
    }

    private void sendEndMessage(Member leaving, Member recipient) {
        this.messageSender.send(InternalMessage.create().from(leaving).to(recipient).signal(Signal.END).content(this.id).build());
    }

    @Override
    public synchronized boolean isWithoutMember() {
        return this.broadcaster == null && this.audience.isEmpty();
    }

    @Override
    public synchronized boolean has(Member from) {
        return this.broadcaster != null && (this.broadcaster.equals(from) || this.audience.contains(from));
    }

    @Override
    public void exchangeSignals(InternalMessage message) {
        this.exchange.execute(message);
    }

    @Override
    public void broadcast(Member from, InternalMessage message) {
        this.audience.stream().filter(member -> !member.equals(from)).forEach(to -> this.messageSender.send(message.copy().from(from).to((Member)to).build()));
        if (from != this.broadcaster) {
            this.messageSender.send(message.copy().from(from).to(this.broadcaster).build());
        }
    }

    private void informSenderThatHasBeenJoined(Member sender) {
        if (this.isWithoutMember()) {
            this.broadcaster = sender;
            this.sendJoinedToBroadcaster(sender, this.id);
        } else {
            this.sendJoinedToConversation(sender, this.id);
            this.sendJoinedFrom(this.broadcaster, sender);
        }
    }

    private void beginSignalExchangeBetweenBroadcasterAndNewAudience(Member sender) {
        if (!sender.equals(this.broadcaster)) {
            this.sendJoinedFrom(sender, this.broadcaster);
            this.exchange.begin(this.broadcaster, sender);
        }
    }

    private void sendJoinedToBroadcaster(Member sender, String id) {
        this.messageSender.send(InternalMessage.create().to(sender).signal(Signal.CREATED).addCustom("type", "BROADCAST").content(id).build());
    }

    @Override
    public void close() throws IOException {
        this.remove(this.broadcaster);
    }

    @Inject
    public void setExchange(ExchangeSignalsBetweenMembers exchange) {
        this.exchange = exchange;
    }

    @Override
    public Member getCreator() {
        return this.broadcaster;
    }

    @Override
    public Set<NextRTCMember> getMembers() {
        return Sets.newHashSet(this.audience);
    }
}

