/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain.conversation;

import java.util.HashSet;
import org.nextrtc.signalingserver.cases.ExchangeSignalsBetweenMembers;
import org.nextrtc.signalingserver.cases.LeftConversation;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.conversation.AbstractMeshConversation;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class MeshWithMasterConversation
extends AbstractMeshConversation {
    private Member owner;

    public MeshWithMasterConversation(String id) {
        super(id);
    }

    public MeshWithMasterConversation(String id, LeftConversation left, MessageSender sender, ExchangeSignalsBetweenMembers exchange) {
        super(id, left, sender, exchange);
    }

    @Override
    public String getTypeName() {
        return "MESH_WITH_MASTER";
    }

    @Override
    public synchronized void join(Member sender) {
        if (this.isWithoutMember()) {
            this.owner = sender;
        }
        super.join(sender);
    }

    @Override
    public synchronized boolean remove(Member leaving) {
        boolean remove = super.remove(leaving);
        if (remove && this.owner.equals(leaving)) {
            new HashSet<Member>(this.members()).forEach(x$0 -> super.remove((Member)x$0));
        }
        return remove;
    }

    @Override
    public Member getCreator() {
        return this.owner;
    }
}

