/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.domain.resolver;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.nextrtc.signalingserver.cases.SignalHandler;
import org.nextrtc.signalingserver.domain.Signal;
import org.nextrtc.signalingserver.domain.SignalResolver;

public abstract class AbstractSignalResolver
implements SignalResolver {
    private final Map<Signal, SignalHandler> customHandlers = new ConcurrentHashMap<Signal, SignalHandler>();

    public AbstractSignalResolver(Map<String, SignalHandler> handlers) {
        this.customHandlers.put(Signal.EMPTY, msg -> {});
        Map<Signal, SignalHandler> collect = handlers.entrySet().stream().collect(Collectors.toMap(k -> Signal.byHandlerName((String)k.getKey()), Map.Entry::getValue));
        this.customHandlers.putAll(collect);
    }

    @Override
    public Pair<Signal, SignalHandler> resolve(String string) {
        Signal signal = Signal.fromString(string);
        if (this.customHandlers.containsKey(signal)) {
            return new ImmutablePair((Object)signal, (Object)this.customHandlers.get(signal));
        }
        return new ImmutablePair((Object)Signal.EMPTY, (Object)this.customHandlers.get(Signal.EMPTY));
    }

    @Override
    public Optional<Pair<Signal, SignalHandler>> addCustomSignal(Signal signal, SignalHandler handler) {
        SignalHandler oldValue = this.customHandlers.put(signal, handler);
        if (oldValue == null) {
            return Optional.empty();
        }
        return Optional.of(new ImmutablePair((Object)signal, (Object)handler));
    }

    protected void initByDefault() {
        for (Signal signal : Signal.values()) {
            SignalHandler handler = this.getHandler(signal);
            this.addCustomSignal(signal, handler);
        }
    }

    private SignalHandler getHandler(Signal signal) {
        return Optional.ofNullable(this.customHandlers.get(signal)).orElse(this.customHandlers.get(Signal.EMPTY));
    }
}

