/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.eventbus;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import org.nextrtc.signalingserver.api.NextRTCEvents;
import org.nextrtc.signalingserver.api.NextRTCHandler;
import org.nextrtc.signalingserver.api.dto.NextRTCEvent;
import org.nextrtc.signalingserver.eventbus.EventDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventDispatcher
implements EventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(AbstractEventDispatcher.class);

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void handle(NextRTCEvent event) {
        this.getNextRTCEventListeners().parallelStream().filter(listener -> this.isNextRTCHandler(listener) && this.supportsCurrentEvent(listener, event)).forEach(listener -> this.doTry(() -> ((NextRTCHandler)listener).handleEvent(event)));
    }

    protected abstract Collection<Object> getNextRTCEventListeners();

    private void doTry(Runnable action) {
        try {
            action.run();
        }
        catch (Exception e) {
            log.error("Handler throws an exception", (Throwable)e);
        }
    }

    private boolean isNextRTCHandler(Object listener) {
        return listener instanceof NextRTCHandler;
    }

    private boolean supportsCurrentEvent(Object listener, NextRTCEvent event) {
        NextRTCEvents[] events = this.getSupportedEvents(listener);
        if (events == null) {
            return false;
        }
        for (NextRTCEvents supportedEvent : events) {
            if (!this.isSupporting(event, supportedEvent)) continue;
            return true;
        }
        return false;
    }

    private boolean isSupporting(NextRTCEvent msg, NextRTCEvents supportedEvent) {
        return supportedEvent.equals((Object)msg.type());
    }

    protected abstract NextRTCEvents[] getSupportedEvents(Object var1);
}

