/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.factory;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.factory.ConversationFactory;
import org.nextrtc.signalingserver.property.NextRTCProperties;

public abstract class AbstractConversationFactory
implements ConversationFactory {
    private final Map<String, Function<String, Conversation>> supportedTypes = new ConcurrentHashMap<String, Function<String, Conversation>>();
    private final NextRTCProperties properties;

    AbstractConversationFactory(NextRTCProperties properties) {
        this.properties = properties;
    }

    @Override
    public final Conversation create(String id, String optionalType) {
        String conversationName = this.getConversationName(id);
        if (this.supportedTypes.containsKey(StringUtils.defaultString((String)optionalType))) {
            return this.supportedTypes.get(optionalType).apply(conversationName);
        }
        return this.supportedTypes.get(this.properties.getDefaultConversationType()).apply(conversationName);
    }

    public Function<String, Conversation> registerConversationType(String type, Function<String, Conversation> creator) {
        return this.supportedTypes.put(type, creator);
    }

    private String getConversationName(String name) {
        return StringUtils.isBlank((CharSequence)name) ? UUID.randomUUID().toString() : name;
    }
}

