/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.factory;

import javax.inject.Inject;
import org.nextrtc.signalingserver.cases.ExchangeSignalsBetweenMembers;
import org.nextrtc.signalingserver.cases.LeftConversation;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.domain.conversation.BroadcastConversation;
import org.nextrtc.signalingserver.domain.conversation.MeshConversation;
import org.nextrtc.signalingserver.domain.conversation.MeshWithMasterConversation;
import org.nextrtc.signalingserver.factory.AbstractConversationFactory;
import org.nextrtc.signalingserver.property.NextRTCProperties;

public class ManualConversationFactory
extends AbstractConversationFactory {
    private MessageSender sender;
    private LeftConversation leftConversation;
    private ExchangeSignalsBetweenMembers exchange;

    @Inject
    public ManualConversationFactory(LeftConversation leftConversation, ExchangeSignalsBetweenMembers exchange, MessageSender sender, NextRTCProperties properties) {
        super(properties);
        this.leftConversation = leftConversation;
        this.exchange = exchange;
        this.sender = sender;
        this.registerConversationType("MESH", this::createMesh);
        this.registerConversationType("BROADCAST", this::createBroadcast);
        this.registerConversationType("MESH_WITH_MASTER", this::createMeshWithMaster);
    }

    private Conversation createMesh(String conversationName) {
        return new MeshConversation(conversationName, this.leftConversation, this.sender, this.exchange);
    }

    private Conversation createMeshWithMaster(String conversationName) {
        return new MeshWithMasterConversation(conversationName, this.leftConversation, this.sender, this.exchange);
    }

    private Conversation createBroadcast(String conversationName) {
        return new BroadcastConversation(conversationName, this.leftConversation, this.sender, this.exchange);
    }
}

