/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.factory;

import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.conversation.BroadcastConversation;
import org.nextrtc.signalingserver.domain.conversation.MeshConversation;
import org.nextrtc.signalingserver.domain.conversation.MeshWithMasterConversation;
import org.nextrtc.signalingserver.factory.AbstractConversationFactory;
import org.nextrtc.signalingserver.property.NextRTCProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SpringConversationFactory
extends AbstractConversationFactory {
    private ApplicationContext context;

    @Autowired
    public SpringConversationFactory(ApplicationContext context, NextRTCProperties properties) {
        super(properties);
        this.context = context;
        this.registerConversationType("MESH", this::createMesh);
        this.registerConversationType("MESH_WITH_MASTER", this::createMeshWithMaster);
        this.registerConversationType("BROADCAST", this::createBroadcast);
    }

    private Conversation createMesh(String conversationName) {
        return (Conversation)this.context.getBean(MeshConversation.class, new Object[]{conversationName});
    }

    private Conversation createMeshWithMaster(String conversationName) {
        return (Conversation)this.context.getBean(MeshWithMasterConversation.class, new Object[]{conversationName});
    }

    private Conversation createBroadcast(String conversationName) {
        return (Conversation)this.context.getBean(BroadcastConversation.class, new Object[]{conversationName});
    }
}

