/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.modules;

import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import dagger.multibindings.StringKey;
import javax.inject.Singleton;
import org.nextrtc.signalingserver.api.NextRTCEventBus;
import org.nextrtc.signalingserver.cases.AnswerResponseHandler;
import org.nextrtc.signalingserver.cases.CandidateHandler;
import org.nextrtc.signalingserver.cases.CreateConversation;
import org.nextrtc.signalingserver.cases.JoinConversation;
import org.nextrtc.signalingserver.cases.LeftConversation;
import org.nextrtc.signalingserver.cases.OfferResponseHandler;
import org.nextrtc.signalingserver.cases.SignalHandler;
import org.nextrtc.signalingserver.cases.TextMessage;
import org.nextrtc.signalingserver.domain.MessageSender;
import org.nextrtc.signalingserver.factory.ConversationFactory;
import org.nextrtc.signalingserver.property.NextRTCProperties;
import org.nextrtc.signalingserver.repository.ConversationRepository;

@Module
public abstract class NextRTCSignals {
    @Provides
    @Singleton
    @IntoMap
    @StringKey(value="nextRTC_ANSWER_RESPONSE")
    static SignalHandler AnswerResponseHandler() {
        return new AnswerResponseHandler();
    }

    @Provides
    @Singleton
    @IntoMap
    @StringKey(value="nextRTC_CANDIDATE")
    static SignalHandler CandidateHandler() {
        return new CandidateHandler();
    }

    @Provides
    @Singleton
    @IntoMap
    @StringKey(value="nextRTC_CREATE")
    static SignalHandler CreateConversationEntry(CreateConversation conversation) {
        return conversation;
    }

    @Provides
    @Singleton
    static CreateConversation CreateConversation(NextRTCEventBus eventBus, ConversationRepository conversations, ConversationFactory factory) {
        return new CreateConversation(eventBus, conversations, factory);
    }

    @Provides
    @Singleton
    @IntoMap
    @StringKey(value="nextRTC_JOIN")
    static SignalHandler JoinConversation(ConversationRepository conversations, CreateConversation create, NextRTCProperties properties) {
        return new JoinConversation(conversations, create, properties);
    }

    @Provides
    @Singleton
    @IntoMap
    @StringKey(value="nextRTC_LEFT")
    static SignalHandler LeftConversation(NextRTCEventBus eventBus, ConversationRepository conversations) {
        return new LeftConversation(eventBus, conversations);
    }

    @Provides
    @Singleton
    @IntoMap
    @StringKey(value="nextRTC_OFFER_RESPONSE")
    static SignalHandler OfferResponseHandler() {
        return new OfferResponseHandler();
    }

    @Provides
    @Singleton
    @IntoMap
    @StringKey(value="nextRTC_TEXT")
    static SignalHandler TextMessage(NextRTCEventBus eventBus, MessageSender sender) {
        return new TextMessage(eventBus, sender);
    }
}

