/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.repository;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.nextrtc.signalingserver.domain.Conversation;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.exception.Exceptions;
import org.nextrtc.signalingserver.repository.ConversationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class Conversations
implements ConversationRepository {
    private static final Logger log = LoggerFactory.getLogger(Conversations.class);
    private Map<String, Conversation> conversations = Maps.newConcurrentMap();

    @Override
    public Optional<Conversation> findBy(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.conversations.get(id));
    }

    @Override
    public Optional<Conversation> findBy(Member from) {
        return this.conversations.values().stream().filter(conversation -> conversation.has(from)).findAny();
    }

    @Override
    public Conversation remove(String id) {
        return this.conversations.remove(id);
    }

    @Override
    public Conversation save(Conversation conversation) {
        if (this.conversations.containsKey(conversation.getId())) {
            throw Exceptions.CONVERSATION_NAME_OCCUPIED.exception();
        }
        this.conversations.put(conversation.getId(), conversation);
        return conversation;
    }

    @Override
    public Collection<String> getAllIds() {
        return this.conversations.keySet();
    }

    @Override
    public void close() throws IOException {
        for (Conversation conversation : this.conversations.values()) {
            try {
                conversation.close();
            }
            catch (Exception e) {
                log.error("Problem during closing conversation " + conversation.getId(), (Throwable)e);
            }
        }
    }
}

