/*
 * Decompiled with CFR 0.152.
 */
package org.nextrtc.signalingserver.repository;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.nextrtc.signalingserver.domain.Member;
import org.nextrtc.signalingserver.repository.MemberRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class Members
implements MemberRepository {
    private static final Logger log = LoggerFactory.getLogger(Members.class);
    private Map<String, Member> members = Maps.newConcurrentMap();

    @Override
    public Collection<String> getAllIds() {
        return this.members.keySet();
    }

    @Override
    public Optional<Member> findBy(String id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.members.get(id));
    }

    @Override
    public Member register(Member member) {
        if (!this.members.containsKey(member.getId())) {
            this.members.put(member.getId(), member);
        }
        return member;
    }

    @Override
    public void unregister(String id) {
        this.findBy(id).ifPresent(Member::markLeft);
        Member removed = this.members.remove(id);
        if (removed != null) {
            removed.getConversation().ifPresent(c -> c.left(removed));
        }
    }

    @Override
    public void close() throws IOException {
        for (Member member : this.members.values()) {
            try {
                member.getConnection().close();
            }
            catch (Exception e) {
                log.error("Problem during closing member connection " + member.getId(), (Throwable)e);
            }
        }
        this.members.clear();
    }
}

