/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.snep;

import org.nfctools.llcp.Llcp;
import org.nfctools.llcp.LlcpSocket;
import org.nfctools.llcp.ServiceAccessPoint;
import org.nfctools.snep.FragmentIterator;
import org.nfctools.snep.FragmentReader;
import org.nfctools.snep.Response;
import org.nfctools.snep.SnepMessage;

public abstract class AbstractSnepImpl
implements ServiceAccessPoint {
    protected byte snepVersion = (byte)16;
    protected int maxInformationUnit = 128;
    protected FragmentReader reader = new FragmentReader();
    protected FragmentIterator fragmentIterator;
    protected SnepMessage continueMessage;

    protected AbstractSnepImpl(byte continueMessageCode) {
        this.continueMessage = new SnepMessage(this.snepVersion, continueMessageCode);
    }

    @Override
    public void onLlcpActive(Llcp llcp) {
    }

    @Override
    public void onConnectFailed() {
    }

    @Override
    public void onConnectSucceeded(LlcpSocket llcpSocket) {
    }

    @Override
    public void onSendFailed() {
    }

    @Override
    public void onDisconnect() {
    }

    @Override
    public void onConnectionActive(LlcpSocket llcpSocket) {
    }

    @Override
    public byte[] onInformation(byte[] serviceDataUnit) {
        this.reader.addFragment(serviceDataUnit);
        if (this.reader.isComplete()) {
            byte[] completeMessage = this.reader.getCompleteMessage();
            this.reader.reset();
            SnepMessage snepMessage = new SnepMessage(completeMessage);
            if (snepMessage.getVersion() == this.snepVersion) {
                return this.processMessage(snepMessage);
            }
            return new SnepMessage((int)this.snepVersion, Response.UNSUPPORTED_VERSION).getBytes();
        }
        if (this.reader.isFirstFragment()) {
            return this.continueMessage.getBytes();
        }
        return null;
    }

    protected abstract byte[] processMessage(SnepMessage var1);
}

