/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.snep;

import java.util.Collection;
import java.util.List;
import org.nfctools.llcp.LlcpSocket;
import org.nfctools.llcp.LlcpUtils;
import org.nfctools.ndef.NdefContext;
import org.nfctools.snep.AbstractSnepImpl;
import org.nfctools.snep.FragmentIterator;
import org.nfctools.snep.Request;
import org.nfctools.snep.Response;
import org.nfctools.snep.SnepMessage;
import org.nfctools.snep.Sneplet;

public class SnepServer
extends AbstractSnepImpl {
    private Sneplet sneplet;

    public SnepServer(Sneplet sneplet) {
        super(Response.CONTINUE.getCode());
        this.sneplet = sneplet;
    }

    @Override
    public void onSendSucceeded(LlcpSocket llcpSocket) {
        if (this.fragmentIterator != null && this.fragmentIterator.hasNext()) {
            llcpSocket.sendMessage(this.fragmentIterator.next());
        }
    }

    @Override
    public boolean canAcceptConnection(Object[] parameters) {
        this.maxInformationUnit = 128 + LlcpUtils.getMiuExtension(parameters);
        return true;
    }

    @Override
    protected byte[] processMessage(SnepMessage snepMessage) {
        if (snepMessage.getMessageCode() == Request.PUT.getCode()) {
            List records = NdefContext.getNdefMessageDecoder().decodeToRecords(snepMessage.getInformation());
            this.sneplet.doPut((Collection)records);
            SnepMessage successMessage = new SnepMessage((int)this.snepVersion, Response.SUCCESS);
            return successMessage.getBytes();
        }
        if (snepMessage.getMessageCode() == Request.GET.getCode()) {
            List records = NdefContext.getNdefMessageDecoder().decodeToRecords(snepMessage.getInformation());
            Collection responseRecords = this.sneplet.doGet((Collection)records);
            SnepMessage successMessage = new SnepMessage((int)this.snepVersion, Response.SUCCESS);
            successMessage.setInformation(NdefContext.getNdefMessageEncoder().encode((Iterable)responseRecords));
            this.fragmentIterator = new FragmentIterator(successMessage.getBytes(), this.maxInformationUnit);
            return this.fragmentIterator.next();
        }
        if (snepMessage.getMessageCode() == Request.CONTINUE.getCode()) {
            if (this.fragmentIterator != null && this.fragmentIterator.hasNext()) {
                return this.fragmentIterator.next();
            }
            return new SnepMessage((int)this.snepVersion, Response.BAD_REQUEST).getBytes();
        }
        return new SnepMessage((int)this.snepVersion, Response.NOT_IMPLEMENTED).getBytes();
    }
}

