/**
 * Copyright 2011-2012 Adrian Stabiszewski, as@nfctools.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.nfctools.llcp;

import org.nfctools.llcp.pdu.Connect;

public class PendingConnection {

	private ServiceAccessPoint serviceAccessPoint;
	private long connectionStart;
	private int retries = 0;
	private Connect connectPdu;

	public PendingConnection(ServiceAccessPoint serviceAccessPoint, long connectionStart, Connect connectPdu) {
		this.serviceAccessPoint = serviceAccessPoint;
		this.connectionStart = connectionStart;
		this.connectPdu = connectPdu;
	}

	public ServiceAccessPoint getServiceAccessPoint() {
		return serviceAccessPoint;
	}

	public long getConnectionStart() {
		return connectionStart;
	}

	public void incRetries() {
		retries++;
	}

	public int getRetries() {
		return retries;
	}

	public Connect getConnectPdu() {
		return connectPdu;
	}
}
