/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.llcp;

import java.io.IOException;
import org.nfctools.llcp.LlcpConnectionManager;
import org.nfctools.llcp.pdu.AbstractProtocolDataUnit;
import org.nfctools.llcp.pdu.PduDecoder;
import org.nfctools.llcp.pdu.Symmetry;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;

public class LlcpOverNfcip
implements NFCIPConnectionListener {
    private PduDecoder pduDecoder = new PduDecoder();
    private LlcpConnectionManager connectionManager = new LlcpConnectionManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnection(NFCIPConnection connection) throws IOException {
        this.initFromGeneralBytes(connection.getGeneralBytes());
        try {
            byte[] data;
            byte[] byArray = data = connection.isInitiator() ? this.pduDecoder.encode(new Symmetry()) : connection.receive();
            while (!Thread.interrupted()) {
                AbstractProtocolDataUnit requestPdu = this.pduDecoder.decode(data);
                AbstractProtocolDataUnit responsePdu = requestPdu.processPdu(this.connectionManager);
                byte[] pdu = this.pduDecoder.encode(responsePdu);
                connection.send(pdu);
                data = connection.receive();
            }
        }
        finally {
            this.clearStack();
        }
    }

    private void initFromGeneralBytes(byte[] generalBytes) {
        if (generalBytes.length >= 3 && generalBytes[0] == 70 && generalBytes[1] == 102 && generalBytes[2] == 109) {
            Object[] parameters = this.pduDecoder.decodeParameter(generalBytes, 3);
            this.connectionManager.init(parameters);
        }
    }

    public LlcpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    private void clearStack() {
        this.connectionManager.clearConnections();
    }
}

