/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.snep;

import java.util.List;
import org.nfctools.llcp.Llcp;
import org.nfctools.llcp.LlcpSocket;
import org.nfctools.llcp.ServiceAccessPoint;
import org.nfctools.ndef.NdefContext;
import org.nfctools.snep.AbstractSnepImpl;
import org.nfctools.snep.FragmentIterator;
import org.nfctools.snep.Request;
import org.nfctools.snep.Response;
import org.nfctools.snep.SnepAgent;
import org.nfctools.snep.SnepAgentListener;
import org.nfctools.snep.SnepMessage;
import org.nfctools.snep.SnepRequestContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnepClient
extends AbstractSnepImpl {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SnepAgentListener snepAgentListener;
    private SnepRequestContainer snepRequestContainer = new SnepRequestContainer();
    private boolean connected = false;

    public SnepClient() {
        super(Request.CONTINUE.getCode());
    }

    public void setSnepAgentListener(SnepAgentListener snepAgentListener) {
        this.snepAgentListener = snepAgentListener;
    }

    @Override
    public void onLlcpActive(Llcp llcp) {
        if (this.snepAgentListener != null && this.snepAgentListener.hasDataToSend() && !this.connected) {
            this.log.debug("Connecting to urn:nfc:sn:snep");
            llcp.connectToService("urn:nfc:sn:snep", (ServiceAccessPoint)this);
        }
    }

    @Override
    public void onConnectionActive(LlcpSocket llcpSocket) {
        if (this.snepAgentListener.hasDataToSend()) {
            this.handleActiveConnection(llcpSocket);
        } else {
            this.log.debug("No data to send, disconnecting...");
            llcpSocket.disconnect();
        }
    }

    @Override
    public void onConnectSucceeded(LlcpSocket llcpSocket) {
        this.log.debug("Connection succeeded");
        this.connected = true;
        this.handleActiveConnection(llcpSocket);
    }

    private void handleActiveConnection(LlcpSocket llcpSocket) {
        this.snepAgentListener.onSnepConnection((SnepAgent)this.snepRequestContainer);
        if (this.snepRequestContainer.hasRequest()) {
            this.maxInformationUnit = llcpSocket.getMaximumInformationUnit();
            byte[] responseMessage = this.processSnepRequestContainer();
            llcpSocket.sendMessage(responseMessage);
        }
    }

    @Override
    public void onDisconnect() {
        this.log.debug("Disconnect succeeded");
        this.connected = false;
    }

    private byte[] processSnepRequestContainer() {
        byte[] encodedRecords = NdefContext.getNdefMessageEncoder().encode(this.snepRequestContainer.getRecords());
        SnepMessage snepMessage = new SnepMessage((int)this.snepVersion, this.snepRequestContainer.getRequest());
        snepMessage.setInformation(encodedRecords);
        this.fragmentIterator = new FragmentIterator(snepMessage.getBytes(), this.maxInformationUnit);
        byte[] responseMessage = this.fragmentIterator.next();
        return responseMessage;
    }

    @Override
    public void onSendSucceeded(LlcpSocket llcpSocket) {
        if (this.fragmentIterator.hasNext()) {
            llcpSocket.sendMessage(this.fragmentIterator.next());
        }
    }

    @Override
    public boolean canAcceptConnection(Object[] parameters) {
        return false;
    }

    @Override
    protected byte[] processMessage(SnepMessage snepMessage) {
        if (snepMessage.getMessageCode() == Response.CONTINUE.getCode()) {
            if (this.fragmentIterator != null && this.fragmentIterator.hasNext()) {
                return this.fragmentIterator.next();
            }
        } else if (snepMessage.getMessageCode() == Response.SUCCESS.getCode()) {
            List records = NdefContext.getNdefMessageDecoder().decodeToRecords(snepMessage.getInformation());
            if (this.snepRequestContainer.hasRequest()) {
                this.snepRequestContainer.handleSuccess(records);
                if (this.snepRequestContainer.hasRequest()) {
                    return this.processSnepRequestContainer();
                }
            }
        } else if (this.snepRequestContainer.hasRequest()) {
            this.snepRequestContainer.handleFailure();
        }
        return null;
    }
}

