/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.snep;

import java.util.Collection;
import java.util.List;
import org.nfctools.ndef.Record;
import org.nfctools.snep.GetResponseListener;
import org.nfctools.snep.PutResponseListener;
import org.nfctools.snep.Request;
import org.nfctools.snep.SnepAgent;

public class SnepRequestContainer
implements SnepAgent {
    private Collection<Record> records;
    private GetResponseListener getResponseListener;
    private PutResponseListener putResponseListener;
    private Request request;

    public void doGet(Collection<Record> records, GetResponseListener getResponseListener) {
        this.records = records;
        this.getResponseListener = getResponseListener;
        this.request = Request.GET;
    }

    public void doPut(Collection<Record> records, PutResponseListener putResponseListener) {
        this.records = records;
        this.putResponseListener = putResponseListener;
        this.request = Request.PUT;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public Collection<Record> getRecords() {
        return this.records;
    }

    public Request getRequest() {
        return this.request;
    }

    public GetResponseListener getGetResponseListener() {
        return this.getResponseListener;
    }

    public PutResponseListener getPutResponseListener() {
        return this.putResponseListener;
    }

    public void handleSuccess(List<Record> receivedRecords) {
        Request oldRequest = this.request;
        this.request = null;
        if (oldRequest == Request.GET && this.getResponseListener != null) {
            this.getResponseListener.onGetResponse(receivedRecords, (SnepAgent)this);
        } else if (oldRequest == Request.PUT && this.putResponseListener != null) {
            this.putResponseListener.onSuccess();
        }
    }

    public void handleFailure() {
        Request oldRequest = this.request;
        this.request = null;
        if (oldRequest == Request.GET && this.getResponseListener != null) {
            this.getResponseListener.onFailed();
        } else if (oldRequest == Request.PUT && this.putResponseListener != null) {
            this.putResponseListener.onFailed();
        }
    }
}

