/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.llcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.nfctools.llcp.AddressPair;
import org.nfctools.llcp.Llcp;
import org.nfctools.llcp.LlcpException;
import org.nfctools.llcp.LlcpSocket;
import org.nfctools.llcp.LlcpUtils;
import org.nfctools.llcp.PendingConnection;
import org.nfctools.llcp.ServiceAccessPoint;
import org.nfctools.llcp.ServiceDiscovery;
import org.nfctools.llcp.parameter.LinkTimeOut;
import org.nfctools.llcp.parameter.Miux;
import org.nfctools.llcp.parameter.ServiceName;
import org.nfctools.llcp.parameter.Version;
import org.nfctools.llcp.pdu.AbstractProtocolDataUnit;
import org.nfctools.llcp.pdu.Connect;
import org.nfctools.llcp.pdu.ConnectComplete;
import org.nfctools.llcp.pdu.Disconnect;
import org.nfctools.llcp.pdu.DisconnectedMode;
import org.nfctools.llcp.pdu.Symmetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlcpConnectionManager
implements Llcp {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final int SERVICE_DISCOVERY_ADDRESS = 1;
    private final int PREFERRED_MIUX = 120;
    private final int MAX_CONNECT_WAIT = 200;
    private static final int MAX_RETRIES = 4;
    private static final byte VERSION_MAJOR = 1;
    private int miuExtension = 120;
    private int linkTimeOut = 200;
    private ServiceDiscovery serviceDiscovery = new ServiceDiscovery();
    private Map<Integer, PendingConnection> pendingConnections = new HashMap<Integer, PendingConnection>();
    private Map<Integer, LlcpSocket> openConnections = new HashMap<Integer, LlcpSocket>();
    private Map<Integer, ServiceAccessPoint> services = new HashMap<Integer, ServiceAccessPoint>();
    private AbstractProtocolDataUnit messageToSend = null;

    public void registerWellKnownServiceAccessPoint(String serviceName, ServiceAccessPoint serviceAccessPoint) {
        this.serviceDiscovery.registerSerivce(serviceName, serviceAccessPoint);
    }

    public void registerServiceAccessPoint(ServiceAccessPoint serviceAccessPoint) {
        this.services.put(this.getFreeLocalServiceAddress(), serviceAccessPoint);
    }

    public void registerServiceAccessPoint(int serviceAddress, ServiceAccessPoint serviceAccessPoint) {
        this.services.put(serviceAddress, serviceAccessPoint);
    }

    private Integer getFreeLocalServiceAddress() {
        for (int x = 16; x < 32; ++x) {
            Integer address = x;
            if (this.services.containsKey(address)) continue;
            return address;
        }
        throw new LlcpException("No more free ports");
    }

    private Integer getFreeOutgoingAddress() {
        HashSet<Integer> usedAddresses = new HashSet<Integer>();
        usedAddresses.addAll(this.openConnections.keySet());
        usedAddresses.addAll(this.pendingConnections.keySet());
        for (int x = 32; x < 64; ++x) {
            Integer address = x;
            if (usedAddresses.contains(address)) continue;
            return address;
        }
        throw new LlcpException("No more free ports");
    }

    public void clearConnections() {
        for (PendingConnection pendingConnection : this.pendingConnections.values()) {
            try {
                pendingConnection.getServiceAccessPoint().onDisconnect();
            }
            catch (Exception e) {
                this.log.warn("Error closing pending connection", (Throwable)e);
            }
        }
        for (LlcpSocket llcpSocket : this.openConnections.values()) {
            try {
                llcpSocket.disconnect();
            }
            catch (Exception e) {
                this.log.warn("Error closing open connection", (Throwable)e);
            }
        }
        this.pendingConnections.clear();
        this.openConnections.clear();
        this.messageToSend = null;
    }

    public ServiceAccessPoint getServiceAccessPoint(int address, String serviceName) {
        if (address == 1) {
            return this.serviceDiscovery.getService(serviceName);
        }
        return this.services.get(address);
    }

    public Collection<Object> getParameter() {
        return Collections.emptyList();
    }

    public AbstractProtocolDataUnit onLlcpActive() {
        this.messageToSend = new Symmetry();
        this.handlePendingConnectionTimeout();
        if (this.pendingConnections.isEmpty()) {
            this.serviceDiscovery.onLlcpActive(this);
            for (Map.Entry<Integer, ServiceAccessPoint> entry : this.services.entrySet()) {
                ServiceAccessPoint serviceAccessPoint = entry.getValue();
                serviceAccessPoint.onLlcpActive(this);
            }
            if (this.messageToSend instanceof Symmetry) {
                for (LlcpSocket llcpSocket : this.openConnections.values()) {
                    llcpSocket.onConnectionActive();
                    this.messageToSend = this.handleMessageToSend(llcpSocket);
                }
            }
        }
        return this.messageToSend;
    }

    private void handlePendingConnectionTimeout() {
        Iterator<PendingConnection> it = this.pendingConnections.values().iterator();
        while (it.hasNext()) {
            PendingConnection pc = it.next();
            long waitingTime = System.currentTimeMillis() - pc.getConnectionStart();
            if (waitingTime <= (long)this.linkTimeOut) continue;
            if (pc.getRetries() > 4) {
                pc.getServiceAccessPoint().onConnectFailed();
                it.remove();
                continue;
            }
            pc.incRetries();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Retrying connect " + pc.getRetries() + " - Waiting time: " + waitingTime);
            }
            this.messageToSend = pc.getConnectPdu();
            return;
        }
    }

    public AbstractProtocolDataUnit onConnectComplete(int remoteAddress, int localAddress, Object[] parameters) {
        this.log.info("connect complete, remote: " + remoteAddress + " lA: " + localAddress);
        Integer pendingLocalAddress = localAddress;
        if (this.pendingConnections.containsKey(pendingLocalAddress)) {
            PendingConnection pendingConnection = this.pendingConnections.remove(pendingLocalAddress);
            LlcpSocket llcpSocket = new LlcpSocket(new AddressPair(remoteAddress, localAddress), pendingConnection.getServiceAccessPoint());
            this.openConnections.put(pendingLocalAddress, llcpSocket);
            this.aggreeOnMiux(parameters, llcpSocket);
            llcpSocket.onConnectSucceeded();
            return this.handleMessageToSend(llcpSocket);
        }
        return new Disconnect(remoteAddress, localAddress);
    }

    private AbstractProtocolDataUnit handleMessageToSend(LlcpSocket llcpSocket) {
        AbstractProtocolDataUnit pdu = llcpSocket.getMessageToSend();
        return pdu;
    }

    @Override
    public void connectToService(String serviceName, ServiceAccessPoint serviceAccessPoint) {
        Object[] parameter = new Object[]{new ServiceName(serviceName)};
        int outgoingAddress = this.getFreeOutgoingAddress();
        Connect connectPdu = new Connect(1, outgoingAddress, parameter);
        this.pendingConnections.put(outgoingAddress, new PendingConnection(serviceAccessPoint, System.currentTimeMillis(), connectPdu));
        this.messageToSend = connectPdu;
    }

    @Override
    public void connectToService(int serviceAddress, ServiceAccessPoint serviceAccessPoint) {
        throw new UnsupportedOperationException();
    }

    private LlcpSocket getOpenLlcpSocket(AddressPair addressPair) {
        return this.getLlcpSocketFromCollection(addressPair, this.openConnections.values());
    }

    private LlcpSocket getLlcpSocketFromCollection(AddressPair addressPair, Collection<LlcpSocket> sockets) {
        for (LlcpSocket llcpSocket : sockets) {
            if (!llcpSocket.equalsAddress(addressPair)) continue;
            return llcpSocket;
        }
        this.log.info("Socket not found for rA: " + addressPair.getRemote() + " lA: " + addressPair.getRemote());
        return null;
    }

    public AbstractProtocolDataUnit onSendConfirmed(int remoteAddress, int localAddress, int receivedSequence) {
        LlcpSocket llcpSocket = this.getOpenLlcpSocket(new AddressPair(remoteAddress, localAddress));
        llcpSocket.onSendConfirmed(receivedSequence);
        return this.handleMessageToSend(llcpSocket);
    }

    public AbstractProtocolDataUnit onConnect(int remoteAddress, int localAddress, Object[] parameters) {
        ServiceAccessPoint serviceAccessPoint = this.getServiceAccessPoint(localAddress, LlcpUtils.getServiceNameFromParameters(parameters));
        if (serviceAccessPoint == null) {
            return new DisconnectedMode(remoteAddress, localAddress, 2);
        }
        if (serviceAccessPoint.canAcceptConnection(parameters)) {
            Integer outgoingAddress = this.getFreeOutgoingAddress();
            LlcpSocket llcpSocket = new LlcpSocket(new AddressPair(remoteAddress, outgoingAddress), serviceAccessPoint);
            this.openConnections.put(outgoingAddress, llcpSocket);
            int aggreeOnMiux = this.aggreeOnMiux(parameters, llcpSocket);
            ArrayList<Object> parameter = new ArrayList<Object>(this.getParameter());
            if (aggreeOnMiux != 0) {
                parameter.add(new Miux(aggreeOnMiux));
            }
            return new ConnectComplete(remoteAddress, outgoingAddress, parameter.toArray());
        }
        return new DisconnectedMode(remoteAddress, localAddress, 3);
    }

    private int aggreeOnMiux(Object[] parameters, LlcpSocket llcpSocket) {
        int remoteMiux = LlcpUtils.getMiuExtension(parameters);
        int aggreeOnMiux = Math.min(this.miuExtension, remoteMiux);
        llcpSocket.setMaximumInformationUnitExtension(aggreeOnMiux);
        return aggreeOnMiux;
    }

    public void init(Object[] parameters) {
        for (Object param : parameters) {
            if (param instanceof Version) {
                Version version = (Version)param;
                this.log.info("LLCP Version: " + version.getMajor() + "." + version.getMinor());
                if (version.getMajor() != 1) {
                    throw new RuntimeException("Cannot handle Version " + version.getMajor());
                }
                if (version.getMinor() != 0) continue;
                this.oldAndroidQuirck();
                continue;
            }
            if (param instanceof Miux) {
                Miux miux = (Miux)param;
                this.miuExtension = Math.min(120, miux.getValue());
                this.log.info("LLCP Miux: " + miux.getValue() + ", agreed on " + this.miuExtension);
                continue;
            }
            if (!(param instanceof LinkTimeOut)) continue;
            LinkTimeOut lto = (LinkTimeOut)param;
            this.linkTimeOut = lto.getValue() * 10;
            this.log.info("LLCP Link Timeout: " + this.linkTimeOut + " ms");
        }
        this.log.info("All params parsed: " + parameters.length);
    }

    private void oldAndroidQuirck() {
        try {
            this.log.info("Waiting...");
            Thread.sleep(100L);
            this.log.info("Done waiting.");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getOpenConnectionsSize() {
        return this.openConnections.size();
    }

    public AbstractProtocolDataUnit onReceiveInformation(int remoteAddress, int localAddress, int received, int send, byte[] serviceDataUnit) {
        LlcpSocket llcpSocket = this.getOpenLlcpSocket(new AddressPair(remoteAddress, localAddress));
        llcpSocket.onInformation(received, send, serviceDataUnit);
        return this.handleMessageToSend(llcpSocket);
    }

    private void closeSocket(LlcpSocket llcpSocket) {
        this.openConnections.values().remove(llcpSocket);
    }

    public AbstractProtocolDataUnit onDisconnect(int remoteAddress, int localAddress) {
        LlcpSocket llcpSocket = this.getOpenLlcpSocket(new AddressPair(remoteAddress, localAddress));
        this.closeSocket(llcpSocket);
        llcpSocket.onDisconnect();
        return this.handleMessageToSend(llcpSocket);
    }

    public AbstractProtocolDataUnit onDisconnectedMode(int remoteAddress, int localAddress, int reason) {
        LlcpSocket llcpSocket = null;
        switch (reason) {
            case 0: {
                llcpSocket = this.getOpenLlcpSocket(new AddressPair(remoteAddress, localAddress));
                if (llcpSocket != null) {
                    this.log.info("Closing open connection");
                    this.closeSocket(llcpSocket);
                    llcpSocket.onDisconnectSucceeded();
                    return this.handleMessageToSend(llcpSocket);
                }
            }
            case 1: {
                llcpSocket = this.getOpenLlcpSocket(new AddressPair(remoteAddress, localAddress));
                if (llcpSocket != null) {
                    this.log.info("Closing open connection");
                    this.closeSocket(llcpSocket);
                    llcpSocket.onDisconnect();
                    return new Symmetry();
                }
            }
            case 2: 
            case 3: 
            case 16: 
            case 17: {
                if (this.pendingConnections.containsKey(localAddress)) {
                    Integer pendingLocalAddress = localAddress;
                    this.log.info("Closing pending connection");
                    PendingConnection pendingConnection = this.pendingConnections.remove(pendingLocalAddress);
                    pendingConnection.getServiceAccessPoint().onConnectFailed();
                }
                return new Symmetry();
            }
            case 32: 
            case 33: {
                return new Symmetry();
            }
        }
        return new Symmetry();
    }
}

