/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.llcp;

import org.nfctools.llcp.AddressPair;
import org.nfctools.llcp.ServiceAccessPoint;
import org.nfctools.llcp.pdu.AbstractProtocolDataUnit;
import org.nfctools.llcp.pdu.Disconnect;
import org.nfctools.llcp.pdu.DisconnectedMode;
import org.nfctools.llcp.pdu.Information;
import org.nfctools.llcp.pdu.ReceiveReady;
import org.nfctools.llcp.pdu.Symmetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlcpSocket {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private AddressPair addressPair;
    private int receivedSequence;
    private int sendSequence;
    private int maximumInformationUnitExtension = 0;
    private AbstractProtocolDataUnit messageToSend;
    private ServiceAccessPoint serviceAccessPoint;

    public LlcpSocket(AddressPair addressPair, ServiceAccessPoint serviceAccessPoint) {
        this.addressPair = addressPair;
        this.serviceAccessPoint = serviceAccessPoint;
    }

    public void setMaximumInformationUnitExtension(int maximumInformationUnitExtension) {
        this.maximumInformationUnitExtension = maximumInformationUnitExtension;
    }

    public void incReceivedSequence() {
        ++this.receivedSequence;
        this.receivedSequence %= 16;
    }

    public void incSendSequence() {
        ++this.sendSequence;
        this.sendSequence %= 16;
    }

    public int getReceivedSequence() {
        return this.receivedSequence;
    }

    public int getSendSequence() {
        return this.sendSequence;
    }

    public void sendMessage(byte[] message) {
        if (message.length > this.getMaximumInformationUnit()) {
            throw new IllegalArgumentException("Message too long. Maximum Information Unit is " + this.getMaximumInformationUnit());
        }
        this.messageToSend = new Information(this.addressPair.getRemote(), this.addressPair.getLocal(), this.getReceivedSequence(), this.getSendSequence(), message);
        this.incSendSequence();
    }

    public void onSendConfirmed(int received) {
        if (this.sendSequence != received) {
            this.log.warn("sequences do not match myS: " + this.sendSequence + " myR: " + this.receivedSequence + " hisR: " + received);
        }
        this.serviceAccessPoint.onSendSucceeded(this);
    }

    protected AbstractProtocolDataUnit getMessageToSend() {
        if (this.messageToSend == null) {
            return new Symmetry();
        }
        AbstractProtocolDataUnit pdu = this.messageToSend;
        this.messageToSend = null;
        return pdu;
    }

    public int getMaximumInformationUnit() {
        return this.maximumInformationUnitExtension + 128;
    }

    public void disconnect() {
        this.messageToSend = new Disconnect(this.addressPair.getRemote(), this.addressPair.getLocal());
    }

    public void onInformation(int received, int send, byte[] serviceDataUnit) {
        if (send != this.receivedSequence) {
            this.log.warn("sequences do not match myS: " + this.sendSequence + " myR: " + this.receivedSequence + " hisS: " + send + " Msg-Length: " + serviceDataUnit.length);
        }
        byte[] information = this.serviceAccessPoint.onInformation(serviceDataUnit);
        this.incReceivedSequence();
        if (information != null) {
            this.sendMessage(information);
        } else {
            this.messageToSend = new ReceiveReady(this.addressPair.getRemote(), this.addressPair.getLocal(), this.getReceivedSequence());
        }
    }

    public void onConnectSucceeded() {
        this.serviceAccessPoint.onConnectSucceeded(this);
    }

    public void onDisconnect() {
        this.serviceAccessPoint.onDisconnect();
        this.messageToSend = new DisconnectedMode(this.addressPair.getRemote(), this.addressPair.getLocal(), 0);
    }

    public void onDisconnectSucceeded() {
        this.serviceAccessPoint.onDisconnect();
    }

    public void onConnectFailed(int reason) {
        this.serviceAccessPoint.onConnectFailed();
    }

    public void onConnectionActive() {
        this.serviceAccessPoint.onConnectionActive(this);
    }

    public boolean equalsAddress(AddressPair addressPair) {
        return this.addressPair.equals(addressPair);
    }
}

