/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.llcp.pdu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.nfctools.llcp.parameter.LinkTimeOut;
import org.nfctools.llcp.parameter.Miux;
import org.nfctools.llcp.parameter.Option;
import org.nfctools.llcp.parameter.ReceiveWindowSize;
import org.nfctools.llcp.parameter.ServiceName;
import org.nfctools.llcp.parameter.Version;
import org.nfctools.llcp.parameter.WellKnownServiceList;
import org.nfctools.llcp.pdu.AbstractParameterProtocolDataUnit;
import org.nfctools.llcp.pdu.AbstractProtocolDataUnit;
import org.nfctools.llcp.pdu.AbstractSequenceProtocolDataUnit;
import org.nfctools.llcp.pdu.Connect;
import org.nfctools.llcp.pdu.ConnectComplete;
import org.nfctools.llcp.pdu.Disconnect;
import org.nfctools.llcp.pdu.DisconnectedMode;
import org.nfctools.llcp.pdu.Information;
import org.nfctools.llcp.pdu.ParameterExchange;
import org.nfctools.llcp.pdu.ReceiveReady;
import org.nfctools.llcp.pdu.Symmetry;
import org.nfctools.llcp.pdu.UnnumberedInformation;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PduDecoder {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractProtocolDataUnit decode(byte[] pduData) {
        int destination = pduData[0] >> 2 & 0x3F;
        int source = pduData[1] & 0x3F;
        int pduType = (pduData[0] & 3) << 2 | (pduData[1] & 0xC0) >> 6;
        switch (pduType) {
            case 4: {
                return new Connect(destination, source, this.decodeParameter(pduData, 2));
            }
            case 6: {
                return new ConnectComplete(destination, source, this.decodeParameter(pduData, 2));
            }
            case 5: {
                return new Disconnect(destination, source);
            }
            case 7: {
                byte reason = pduData[2];
                return new DisconnectedMode(destination, source, reason);
            }
            case 12: {
                int received = pduData[2] & 0xF;
                int send = pduData[2] >>> 4 & 0xF;
                byte[] informationData = new byte[pduData.length - 3];
                System.arraycopy(pduData, 3, informationData, 0, informationData.length);
                return new Information(destination, source, received, send, informationData);
            }
            case 1: {
                return new ParameterExchange(destination, source, this.decodeParameter(pduData, 2));
            }
            case 13: {
                int receivedReady = pduData[2] & 0xF;
                return new ReceiveReady(destination, source, receivedReady);
            }
            case 0: {
                return new Symmetry();
            }
            case 3: {
                byte[] unnumberedData = new byte[pduData.length - 2];
                System.arraycopy(pduData, 2, unnumberedData, 0, unnumberedData.length);
                return new UnnumberedInformation(destination, source, unnumberedData);
            }
            case 2: 
            case 8: 
            case 14: {
                throw new UnsupportedOperationException("PDU TYPE: " + pduType);
            }
        }
        throw new RuntimeException("unknown pdu type: " + pduType);
    }

    public byte[] encode(AbstractProtocolDataUnit protocolDataUnit) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (protocolDataUnit instanceof ConnectComplete) {
            this.appendHeader(baos, protocolDataUnit, 6);
            this.appendParameter(baos, (AbstractParameterProtocolDataUnit)protocolDataUnit);
        } else if (protocolDataUnit instanceof Connect) {
            this.appendHeader(baos, protocolDataUnit, 4);
            this.appendParameter(baos, (AbstractParameterProtocolDataUnit)protocolDataUnit);
        } else if (protocolDataUnit instanceof Disconnect) {
            this.appendHeader(baos, protocolDataUnit, 5);
        } else if (protocolDataUnit instanceof DisconnectedMode) {
            this.appendHeader(baos, protocolDataUnit, 7);
            baos.write(((DisconnectedMode)protocolDataUnit).getReason());
        } else if (protocolDataUnit instanceof Information) {
            this.appendHeader(baos, protocolDataUnit, 12);
            this.appendSequence(baos, (AbstractSequenceProtocolDataUnit)protocolDataUnit);
            this.appendData(baos, ((Information)protocolDataUnit).getServiceDataUnit());
        } else if (protocolDataUnit instanceof ParameterExchange) {
            this.appendHeader(baos, protocolDataUnit, 1);
            this.appendParameter(baos, (AbstractParameterProtocolDataUnit)protocolDataUnit);
        } else if (protocolDataUnit instanceof ReceiveReady) {
            this.appendHeader(baos, protocolDataUnit, 13);
            this.appendSequence(baos, (AbstractSequenceProtocolDataUnit)protocolDataUnit);
        } else if (protocolDataUnit instanceof Symmetry) {
            this.appendHeader(baos, protocolDataUnit, 0);
        } else if (protocolDataUnit instanceof UnnumberedInformation) {
            this.appendHeader(baos, protocolDataUnit, 3);
            this.appendData(baos, ((UnnumberedInformation)protocolDataUnit).getServiceDataUnit());
        }
        return baos.toByteArray();
    }

    private void appendData(ByteArrayOutputStream baos, byte[] data) {
        try {
            baos.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void appendSequence(ByteArrayOutputStream baos, AbstractSequenceProtocolDataUnit protocolDataUnit) {
        int sequence = (protocolDataUnit.getSend() & 0xF) << 4 | protocolDataUnit.getReceived() & 0xF;
        baos.write(sequence);
    }

    private void appendParameter(ByteArrayOutputStream baos, AbstractParameterProtocolDataUnit protocolDataUnit) {
        this.appendData(baos, this.encodeParameter(protocolDataUnit.getParameter()));
    }

    protected void appendHeader(ByteArrayOutputStream baos, AbstractProtocolDataUnit protocolDataUnit, int pduType) {
        int b1 = (protocolDataUnit.getDestinationServiceAccessPoint() & 0x3F) << 2 | pduType >> 2;
        int b2 = (pduType & 3) << 6 | protocolDataUnit.getSourceServiceAccessPoint() & 0x3F;
        baos.write(b1);
        baos.write(b2);
    }

    public Object[] decodeParameter(byte[] pduData) {
        return this.decodeParameter(pduData, 0);
    }

    public Object[] decodeParameter(byte[] pduData, int offset) {
        ArrayList<Object> params = new ArrayList<Object>();
        while (offset < pduData.length) {
            switch (pduData[offset]) {
                case 1: {
                    byte major = (byte)(pduData[offset + 2] >> 4 & 0xF);
                    byte minor = (byte)(pduData[offset + 2] & 0xF);
                    params.add(new Version(major, minor));
                    break;
                }
                case 6: {
                    String serviceName = new String(pduData, offset + 2, (int)pduData[offset + 1]);
                    params.add(new ServiceName(serviceName));
                    break;
                }
                case 2: {
                    int miux = (pduData[offset + 2] & 3) << 8 | pduData[offset + 3] & 0xFF;
                    params.add(new Miux(miux));
                    break;
                }
                case 3: {
                    int wks = (pduData[offset + 2] & 0xFF) << 8 | pduData[offset + 3] & 0xFF;
                    params.add(new WellKnownServiceList(wks));
                    break;
                }
                case 4: {
                    params.add(new LinkTimeOut(pduData[offset + 2] & 0xFF));
                    break;
                }
                case 5: {
                    params.add(new ReceiveWindowSize(pduData[offset + 2] & 0xF));
                    break;
                }
                case 7: {
                    params.add(new Option(pduData[offset + 2] & 1));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown code " + pduData[offset] + " at position " + offset + ". [" + NfcUtils.convertBinToASCII((byte[])pduData) + "]");
                }
            }
            offset += 2 + pduData[offset + 1];
        }
        return params.toArray();
    }

    public byte[] encodeParameter(Object[] parameter) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Object object : parameter) {
            if (object instanceof Version) {
                baos.write(1);
                baos.write(1);
                byte versionByte = this.createVersionByte((Version)object);
                baos.write(versionByte);
                continue;
            }
            if (object instanceof ServiceName) {
                byte[] serviceName = ((ServiceName)object).getName().getBytes();
                baos.write(6);
                baos.write(serviceName.length);
                this.appendData(baos, serviceName);
                continue;
            }
            if (!(object instanceof Miux)) continue;
            Miux miux = (Miux)object;
            baos.write(2);
            baos.write(2);
            baos.write(miux.getValue() >> 8 & 3);
            baos.write(miux.getValue() & 0xFF);
        }
        return baos.toByteArray();
    }

    private byte createVersionByte(Version version) {
        if (version.getMajor() > 15 | version.getMajor() < 1 | version.getMinor() > 15 | version.getMinor() < 0) {
            throw new IllegalArgumentException("Version out of range");
        }
        byte versionByte = (byte)(version.getMajor() << 4 | version.getMinor());
        return versionByte;
    }
}

