/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndefpush;

import java.io.IOException;
import org.nfctools.NfcContext;
import org.nfctools.api.Target;
import org.nfctools.api.TargetListener;
import org.nfctools.llcp.pdu.PduDecoder;
import org.nfctools.spi.tama.nfcip.TamaNfcIpCommunicator;
import org.nfctools.spi.tama.request.SetGeneralBytesReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlcpTargetListener
implements TargetListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private byte[] llcHeader = new byte[]{70, 102, 109};
    private byte[] llcParameters = new byte[0];

    public LlcpTargetListener(byte[] llcParameters) {
        this.llcParameters = llcParameters;
    }

    public void onTarget(Target target, NfcContext nfcContext) throws IOException {
        this.log.info("New target");
        TamaNfcIpCommunicator nfcIpCommunicator = (TamaNfcIpCommunicator)nfcContext.getAttribute("communicator");
        byte[] generalBytes = new byte[this.llcHeader.length + this.llcParameters.length];
        System.arraycopy(this.llcHeader, 0, generalBytes, 0, this.llcHeader.length);
        System.arraycopy(this.llcParameters, 0, generalBytes, this.llcHeader.length, this.llcParameters.length);
        this.log.info("reply...");
        Integer statusCode = (Integer)nfcIpCommunicator.sendMessage((Object)new SetGeneralBytesReq(generalBytes));
        if (statusCode != 0) {
            throw new IOException("status code: " + statusCode);
        }
    }

    protected Object[] extractLlcParameters(byte[] incomingGeneralBytes) {
        byte[] incomingLlcParameters = new byte[]{};
        for (int x = 0; x <= incomingGeneralBytes.length - this.llcHeader.length; ++x) {
            boolean match = true;
            for (int h = 0; h < this.llcHeader.length; ++h) {
                if (incomingGeneralBytes[x + h] == this.llcHeader[h]) continue;
                match = false;
                break;
            }
            if (!match || incomingGeneralBytes.length <= x + this.llcHeader.length) continue;
            incomingLlcParameters = new byte[incomingGeneralBytes.length - x - this.llcHeader.length];
            System.arraycopy(incomingGeneralBytes, x + this.llcHeader.length, incomingLlcParameters, 0, incomingLlcParameters.length);
        }
        PduDecoder pduDecoder = new PduDecoder();
        Object[] parameter = pduDecoder.decodeParameter(incomingLlcParameters, 0);
        return parameter;
    }
}

