/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndefpush;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.nfctools.llcp.Llcp;
import org.nfctools.llcp.LlcpSocket;
import org.nfctools.llcp.ServiceAccessPoint;
import org.nfctools.ndef.NdefContext;
import org.nfctools.ndef.NdefListener;
import org.nfctools.ndef.Record;
import org.nfctools.ndefpush.FormatException;
import org.nfctools.ndefpush.NdefPushFinishListener;
import org.nfctools.ndefpush.NdefPushProtocol;
import org.nfctools.ndefpush.OutgoingNdefMessage;
import org.nfctools.ndefpush.WaitingNdefMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdefPushLlcpService
implements ServiceAccessPoint {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ByteArrayOutputStream incommingBuffer = new ByteArrayOutputStream();
    private NdefListener ndefListener;
    private OutgoingNdefMessage outgoingMessage;
    private BlockingQueue<WaitingNdefMessage> waitingMessages = new LinkedBlockingDeque<WaitingNdefMessage>();

    public NdefPushLlcpService(NdefListener ndefListener) {
        this.ndefListener = ndefListener;
    }

    public void addMessages(Collection<Record> ndefRecords, NdefPushFinishListener finishListener) {
        this.waitingMessages.add(new WaitingNdefMessage(ndefRecords, finishListener));
    }

    public boolean hasMessagesToSend() {
        return !this.waitingMessages.isEmpty();
    }

    @Override
    public void onLlcpActive(Llcp llcp) {
        this.log.debug(this.waitingMessages.size() + " NDEF messages to send");
        if (this.hasMessagesToSend()) {
            llcp.connectToService("com.android.npp", (ServiceAccessPoint)this);
        }
    }

    @Override
    public void onConnectionActive(LlcpSocket llcpSocket) {
        if (this.hasMessagesToSend()) {
            this.handleActiveConnection(llcpSocket);
        } else {
            llcpSocket.disconnect();
        }
    }

    @Override
    public void onConnectFailed() {
        this.log.debug("Connection failed");
    }

    @Override
    public void onConnectSucceeded(LlcpSocket llcpSocket) {
        this.handleActiveConnection(llcpSocket);
    }

    private void handleActiveConnection(LlcpSocket llcpSocket) {
        this.outgoingMessage = new OutgoingNdefMessage();
        while (this.waitingMessages.size() > 0) {
            this.outgoingMessage.addWaitingNdefMessage((WaitingNdefMessage)this.waitingMessages.poll());
        }
        this.outgoingMessage.compile();
        this.log.debug("Connection ok, sending message with " + this.outgoingMessage.getAvailableBytes() + " bytes");
        this.sendMessage(llcpSocket);
    }

    @Override
    public void onSendSucceeded(LlcpSocket llcpSocket) {
        if (this.waitingMessages != null) {
            this.sendMessage(llcpSocket);
        }
    }

    private void sendMessage(LlcpSocket llcpSocket) {
        int messageSize = Math.min(this.outgoingMessage.getAvailableBytes(), llcpSocket.getMaximumInformationUnit());
        if (messageSize > 0) {
            byte[] messageBuffer = new byte[messageSize];
            this.outgoingMessage.readNextBuffer(messageBuffer);
            llcpSocket.sendMessage(messageBuffer);
        } else {
            if (this.waitingMessages.isEmpty()) {
                llcpSocket.disconnect();
            } else {
                this.onConnectSucceeded(llcpSocket);
            }
            this.log.debug("Message send");
            this.outgoingMessage.notifyFinishListenerSuccess();
            this.outgoingMessage = null;
        }
    }

    @Override
    public void onSendFailed() {
        this.log.debug("Send failed");
        if (this.outgoingMessage != null) {
            this.outgoingMessage.notifyFinishListenerFailure();
            this.outgoingMessage = null;
        }
    }

    @Override
    public boolean canAcceptConnection(Object[] parameters) {
        boolean canAcceptConnection = this.ndefListener != null;
        this.log.debug("can connect: " + canAcceptConnection);
        return canAcceptConnection;
    }

    @Override
    public void onDisconnect() {
        this.log.debug("Remote disconnect");
        this.outgoingMessage = null;
    }

    @Override
    public byte[] onInformation(byte[] serviceDataUnit) {
        try {
            this.incommingBuffer.write(serviceDataUnit);
            try {
                List<byte[]> ndefMessages = NdefPushProtocol.parse(this.incommingBuffer.toByteArray());
                if (ndefMessages != null) {
                    for (byte[] ndef : ndefMessages) {
                        List records = NdefContext.getNdefMessageDecoder().decodeToRecords(ndef);
                        if (this.ndefListener == null) continue;
                        this.ndefListener.onNdefMessages((Collection)records);
                    }
                }
                this.incommingBuffer.reset();
            }
            catch (FormatException e) {}
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

