/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndefpush;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.nfctools.ndef.Record;
import org.nfctools.ndefpush.NdefPushFinishListener;
import org.nfctools.ndefpush.NdefPushProtocol;
import org.nfctools.ndefpush.WaitingNdefMessage;

public class OutgoingNdefMessage {
    private ByteArrayInputStream outgoingBuffer;
    private Collection<Record> ndefRecords = new ArrayList<Record>();
    private Collection<NdefPushFinishListener> finishListenerList = new ArrayList<NdefPushFinishListener>();

    public void addWaitingNdefMessage(WaitingNdefMessage waitingNdefMessage) {
        this.ndefRecords.addAll(waitingNdefMessage.getNdefRecords());
        if (waitingNdefMessage.getFinishListener() != null) {
            this.finishListenerList.add(waitingNdefMessage.getFinishListener());
        }
    }

    public void compile() {
        this.outgoingBuffer = new ByteArrayInputStream(NdefPushProtocol.toByteArray(this.ndefRecords));
    }

    public int getAvailableBytes() {
        return this.outgoingBuffer.available();
    }

    public void readNextBuffer(byte[] buffer) {
        try {
            this.outgoingBuffer.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyFinishListenerSuccess() {
        for (NdefPushFinishListener finishListener : this.finishListenerList) {
            try {
                finishListener.onNdefPushFinish();
            }
            catch (Throwable throwable) {}
        }
    }

    public void notifyFinishListenerFailure() {
        for (NdefPushFinishListener finishListener : this.finishListenerList) {
            try {
                finishListener.onNdefPushFailed();
            }
            catch (Throwable throwable) {}
        }
    }
}

