/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.snep;

import java.nio.ByteBuffer;
import org.nfctools.snep.Request;
import org.nfctools.snep.Response;

public class SnepMessage {
    private byte version;
    private byte messageCode;
    private long length;
    private byte[] information;

    public SnepMessage(byte[] message) {
        ByteBuffer buffer = ByteBuffer.wrap(message);
        this.version = buffer.get();
        this.messageCode = buffer.get();
        this.length = buffer.getInt();
        this.information = new byte[(int)this.length];
        buffer.get(this.information);
    }

    public SnepMessage(byte version, byte messageCode) {
        this.version = version;
        this.messageCode = messageCode;
    }

    public SnepMessage(int version, Request request) {
        this.version = (byte)version;
        this.messageCode = request.getCode();
    }

    public SnepMessage(int version, Response response) {
        this.version = (byte)version;
        this.messageCode = response.getCode();
    }

    public void setInformation(byte[] information) {
        this.information = information;
        this.length = information.length;
    }

    public byte[] getInformation() {
        return this.information;
    }

    public byte getMessageCode() {
        return this.messageCode;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate((int)(6L + this.length));
        buffer.put(this.version);
        buffer.put(this.messageCode);
        buffer.putInt((int)this.length);
        if (this.information != null) {
            buffer.put(this.information);
        }
        return buffer.array();
    }
}

