/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndefpush;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nfctools.ndef.NdefContext;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.Record;
import org.nfctools.ndefpush.FormatException;

public class NdefPushProtocol {
    public static final byte ACTION_IMMEDIATE = 1;
    public static final byte ACTION_BACKGROUND = 2;
    private static final byte VERSION = 1;

    public static List<byte[]> parse(byte[] data) throws FormatException {
        ArrayList<byte[]> messages = new ArrayList<byte[]>();
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(buffer);
        try {
            byte version = input.readByte();
            if (version != 1) {
                throw new FormatException("Got version " + version + ",  expected " + 1);
            }
            int numMessages = input.readInt();
            if (numMessages == 0) {
                throw new FormatException("Error while parsing NdefMessage");
            }
            byte[] actions = new byte[numMessages];
            for (int i = 0; i < numMessages; ++i) {
                byte[] bytes;
                int readLength;
                actions[i] = input.readByte();
                int messageLength = input.readInt();
                if (messageLength != (readLength = input.read(bytes = new byte[messageLength]))) {
                    throw new FormatException("Error while parsing NdefMessage");
                }
                messages.add(bytes);
            }
        }
        catch (IOException e) {
            throw new FormatException("Error while parsing NdefMessage", e);
        }
        return messages;
    }

    public static byte[] toByteArray(Collection<Record> records) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
        DataOutputStream output = new DataOutputStream(buffer);
        NdefMessageEncoder ndefMessageEncoder = NdefContext.getNdefMessageEncoder();
        try {
            byte[] bytes = ndefMessageEncoder.encode(records);
            output.writeByte(1);
            output.writeInt(1);
            output.writeByte(1);
            output.writeInt(bytes.length);
            output.write(bytes);
        }
        catch (IOException e) {
            return null;
        }
        return buffer.toByteArray();
    }
}

