/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.nfcip;

import java.io.IOException;
import org.nfctools.api.ApduTag;
import org.nfctools.api.NfcTagListener;
import org.nfctools.api.Tag;
import org.nfctools.api.TagType;
import org.nfctools.io.ByteArrayReader;
import org.nfctools.io.ByteArrayWriter;
import org.nfctools.llcp.LlcpConstants;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;
import org.nfctools.spi.acs.ApduTagReaderWriter;
import org.nfctools.spi.tama.nfcip.TamaNfcIpCommunicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFCIPTagListener
implements NfcTagListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private NFCIPConnectionListener nfcipConnectionListener;

    public NFCIPTagListener(NFCIPConnectionListener nfcipConnectionListener) {
        this.nfcipConnectionListener = nfcipConnectionListener;
    }

    public boolean canHandle(Tag tag) {
        return tag.getTagType().equals((Object)TagType.NFCIP);
    }

    public void handleTag(Tag tag) {
        ApduTagReaderWriter apduReaderWriter = new ApduTagReaderWriter((ApduTag)tag);
        TamaNfcIpCommunicator nfcIpCommunicator = new TamaNfcIpCommunicator((ByteArrayReader)apduReaderWriter, (ByteArrayWriter)apduReaderWriter);
        nfcIpCommunicator.setConnectionSetup(LlcpConstants.CONNECTION_SETUP);
        try {
            NFCIPConnection nfcipConnection = nfcIpCommunicator.connectAsInitiator();
            this.log.info("Connection: " + nfcipConnection);
            this.handleNfcipConnection(nfcipConnection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void handleNfcipConnection(NFCIPConnection nfcipConnection) throws IOException {
        if (nfcipConnection != null && this.nfcipConnectionListener != null) {
            this.nfcipConnectionListener.onConnection(nfcipConnection);
        }
    }
}

